/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.jclouds.virtualbox.domain.RedirectRule;
import org.virtualbox_4_2.NATProtocol;

public class NatAdapter {
    private final Set<RedirectRule> redirectRules = Sets.newLinkedHashSet();

    public NatAdapter(Set<RedirectRule> redirectRules) {
        Preconditions.checkNotNull(redirectRules);
        this.redirectRules.addAll(redirectRules);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<RedirectRule> getRedirectRules() {
        return Collections.unmodifiableSet(this.redirectRules);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NatAdapter) {
            NatAdapter other = (NatAdapter)o;
            return Objects.equal(this.redirectRules, other.redirectRules);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.redirectRules});
    }

    public String toString() {
        return "NatAdapter{redirectRules=" + this.redirectRules + '}';
    }

    public static class Builder {
        private Set<RedirectRule> redirectRules = Sets.newLinkedHashSet();

        public Builder tcpRedirectRule(String host, int hostPort, String guest, int guestPort) {
            this.redirectRules.add(new RedirectRule(NATProtocol.TCP, host, hostPort, guest, guestPort));
            return this;
        }

        public Builder udpRedirectRule(String host, int hostPort, String guest, int guestPort) {
            this.redirectRules.add(new RedirectRule(NATProtocol.UDP, host, hostPort, guest, guestPort));
            return this;
        }

        public NatAdapter build() {
            return new NatAdapter(this.redirectRules);
        }
    }
}

