/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import org.jclouds.compute.domain.Template;
import org.jclouds.virtualbox.domain.Master;

public class NodeSpec {
    private final Master master;
    private final String name;
    private final String tag;
    private final Template template;

    public static Builder builder() {
        return new Builder();
    }

    private NodeSpec(Master master, String name, String tag, Template template) {
        this.master = master;
        this.name = name;
        this.tag = tag;
        this.template = template;
    }

    public Master getMaster() {
        return this.master;
    }

    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public Template getTemplate() {
        return this.template;
    }

    public static class Builder {
        private Master master;
        private String name;
        private String tag;
        private Template template;

        public Builder master(Master master) {
            this.master = master;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder template(Template template) {
            this.template = template;
            return this;
        }

        public NodeSpec build() {
            return new NodeSpec(this.master, this.name, this.tag, this.template);
        }
    }
}

