/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.virtualbox_4_2.NATProtocol;

public class RedirectRule {
    private final NATProtocol protocol;
    private final String host;
    private final int hostPort;
    private final String guest;
    private final int guestPort;

    public RedirectRule(NATProtocol protocol, String host, int hostPort, String guest, int guestPort) {
        Preconditions.checkNotNull((Object)protocol);
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)guest);
        this.protocol = protocol;
        this.host = host;
        this.hostPort = hostPort;
        this.guest = guest;
        this.guestPort = guestPort;
    }

    public NATProtocol getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public String getGuest() {
        return this.guest;
    }

    public int getGuestPort() {
        return this.guestPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RedirectRule) {
            RedirectRule other = (RedirectRule)o;
            return Objects.equal((Object)this.protocol, (Object)other.protocol) && Objects.equal((Object)this.host, (Object)other.host) && Objects.equal((Object)this.hostPort, (Object)other.hostPort) && Objects.equal((Object)this.guest, (Object)other.guest) && Objects.equal((Object)this.guestPort, (Object)other.guestPort);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.protocol, this.host, this.hostPort, this.guest, this.guestPort});
    }

    public String toString() {
        return "RedirectRule{protocol=" + this.protocol + ", host='" + this.host + '\'' + ", hostPort=" + this.hostPort + ", guest='" + this.guest + '\'' + ", guestPort=" + this.guestPort + '}';
    }
}

