/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.jclouds.virtualbox.domain.StorageController;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.VBoxException;

public class AddIDEControllerIfNotExists
implements Function<IMachine, Void> {
    private final StorageController storageController;

    public AddIDEControllerIfNotExists(StorageController storageController) {
        this.storageController = (StorageController)Preconditions.checkNotNull((Object)storageController, (Object)"storageController can't be null");
    }

    public Void apply(IMachine machine) {
        block2: {
            try {
                machine.addStorageController(this.storageController.getName(), this.storageController.getBus());
                machine.saveSettings();
            }
            catch (VBoxException e) {
                if (e.getMessage().contains("already exists")) break block2;
                throw e;
            }
        }
        return null;
    }

    public String toString() {
        return String.format("addStorageController(%s)", this.storageController);
    }
}

