/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.INetworkAdapter;
import org.virtualbox_4_2.NetworkAttachmentType;

public class AttachHostOnlyAdapter
implements Function<IMachine, Void> {
    private NetworkInterfaceCard networkInterfaceCard;

    public AttachHostOnlyAdapter(NetworkInterfaceCard networkInterfaceCard) {
        this.networkInterfaceCard = networkInterfaceCard;
    }

    public Void apply(IMachine machine) {
        INetworkAdapter iNetworkAdapter = machine.getNetworkAdapter(Long.valueOf(this.networkInterfaceCard.getSlot()));
        iNetworkAdapter.setAttachmentType(NetworkAttachmentType.HostOnly);
        iNetworkAdapter.setMACAddress(this.networkInterfaceCard.getNetworkAdapter().getMacAddress());
        iNetworkAdapter.setHostOnlyInterface(this.networkInterfaceCard.getHostInterfaceName());
        iNetworkAdapter.setEnabled(Boolean.valueOf(this.networkInterfaceCard.isEnabled()));
        machine.saveSettings();
        return null;
    }
}

