/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import org.jclouds.virtualbox.domain.DeviceDetails;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IMedium;
import org.virtualbox_4_2.VBoxException;

public class AttachMediumToMachineIfNotAlreadyAttached
implements Function<IMachine, Void> {
    private final DeviceDetails device;
    private final IMedium medium;
    private final String controllerName;

    public AttachMediumToMachineIfNotAlreadyAttached(DeviceDetails device, IMedium medium, String controllerName) {
        this.device = device;
        this.medium = medium;
        this.controllerName = controllerName;
    }

    public Void apply(IMachine machine) {
        block2: {
            try {
                machine.attachDevice(this.controllerName, Integer.valueOf(this.device.getPort()), Integer.valueOf(this.device.getDeviceSlot()), this.device.getDeviceType(), this.medium);
                machine.saveSettings();
            }
            catch (VBoxException e) {
                if (this.alreadyAttached(e)) break block2;
                throw e;
            }
        }
        return null;
    }

    private boolean alreadyAttached(VBoxException e) {
        System.out.println(this.medium.getName() + " " + e.getMessage());
        return e.getMessage().contains("is already attached to port");
    }
}

