/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;
import org.jclouds.virtualbox.domain.RedirectRule;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.INetworkAdapter;
import org.virtualbox_4_2.NetworkAttachmentType;
import org.virtualbox_4_2.VBoxException;

public class AttachNATAdapterToMachineIfNotAlreadyExists
implements Function<IMachine, Void> {
    private NetworkInterfaceCard networkInterfaceCard;

    public AttachNATAdapterToMachineIfNotAlreadyExists(NetworkInterfaceCard networkInterfaceCard) {
        this.networkInterfaceCard = networkInterfaceCard;
    }

    public Void apply(IMachine machine) {
        INetworkAdapter iNetworkAdapter = machine.getNetworkAdapter(Long.valueOf(this.networkInterfaceCard.getSlot()));
        for (String redirectRule : iNetworkAdapter.getNATEngine().getRedirects()) {
            String redirectRuleName = (String)Iterables.getFirst((Iterable)Splitter.on((String)",").split((CharSequence)redirectRule), null);
            if (redirectRuleName == null) continue;
            iNetworkAdapter.getNATEngine().removeRedirect(redirectRuleName);
        }
        iNetworkAdapter.setAttachmentType(NetworkAttachmentType.NAT);
        for (RedirectRule rule : this.networkInterfaceCard.getNetworkAdapter().getRedirectRules()) {
            try {
                String ruleName = String.format("%s@%s:%s->%s:%s", rule.getProtocol(), rule.getHost(), rule.getHostPort(), rule.getGuest(), rule.getGuestPort());
                iNetworkAdapter.getNATEngine().addRedirect(ruleName, rule.getProtocol(), rule.getHost(), Integer.valueOf(rule.getHostPort()), rule.getGuest(), Integer.valueOf(rule.getGuestPort()));
            }
            catch (VBoxException e) {
                if (e.getMessage().contains("already exists")) continue;
                throw e;
            }
        }
        iNetworkAdapter.setEnabled(Boolean.valueOf(this.networkInterfaceCard.isEnabled()));
        machine.saveSettings();
        return null;
    }
}

