/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.domain.DeviceDetails;
import org.jclouds.virtualbox.domain.HardDisk;
import org.jclouds.virtualbox.domain.IsoImage;
import org.jclouds.virtualbox.domain.MasterSpec;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;
import org.jclouds.virtualbox.domain.NetworkSpec;
import org.jclouds.virtualbox.domain.StorageController;
import org.jclouds.virtualbox.domain.VmSpec;
import org.jclouds.virtualbox.functions.AddIDEControllerIfNotExists;
import org.jclouds.virtualbox.functions.ApplyBootOrderToMachine;
import org.jclouds.virtualbox.functions.ApplyMemoryToMachine;
import org.jclouds.virtualbox.functions.AttachMediumToMachineIfNotAlreadyAttached;
import org.jclouds.virtualbox.functions.AttachNicToMachine;
import org.jclouds.virtualbox.functions.CreateMediumIfNotAlreadyExists;
import org.jclouds.virtualbox.util.MachineUtils;
import org.virtualbox_4_2.AccessMode;
import org.virtualbox_4_2.DeviceType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IMedium;
import org.virtualbox_4_2.IVirtualBox;
import org.virtualbox_4_2.VBoxException;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class CreateAndRegisterMachineFromIsoIfNotAlreadyExists
implements Function<MasterSpec, IMachine> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<VirtualBoxManager> manager;
    private final MachineUtils machineUtils;
    private final String workingDir;

    @Inject
    public CreateAndRegisterMachineFromIsoIfNotAlreadyExists(Supplier<VirtualBoxManager> manager, MachineUtils machineUtils, @Named(value="jclouds.virtualbox.workingdir") String workingDir) {
        this.manager = manager;
        this.machineUtils = machineUtils;
        this.workingDir = workingDir;
    }

    public IMachine apply(MasterSpec masterSpec) {
        IVirtualBox vBox = ((VirtualBoxManager)this.manager.get()).getVBox();
        String vmName = masterSpec.getVmSpec().getVmName();
        String vmId = masterSpec.getVmSpec().getVmId();
        try {
            vBox.findMachine(vmId);
            throw new IllegalStateException("Machine " + vmName + " is already registered.");
        }
        catch (VBoxException e) {
            if (MachineUtils.machineNotFoundException(e)) {
                return this.createMachine(vBox, masterSpec);
            }
            throw e;
        }
    }

    private IMachine createMachine(IVirtualBox vBox, MasterSpec masterSpec) {
        VmSpec vmSpec = masterSpec.getVmSpec();
        String flags = "";
        ArrayList groups = Lists.newArrayList();
        String group = "";
        String settingsFile = ((VirtualBoxManager)this.manager.get()).getVBox().composeMachineFilename(vmSpec.getVmName(), group, flags, this.workingDir);
        IMachine newMachine = vBox.createMachine(settingsFile, vmSpec.getVmName(), (List)groups, vmSpec.getOsTypeId(), flags);
        ((VirtualBoxManager)this.manager.get()).getVBox().registerMachine(newMachine);
        this.ensureConfiguration(masterSpec);
        return newMachine;
    }

    private void ensureConfiguration(MasterSpec machineSpec) {
        VmSpec vmSpec = machineSpec.getVmSpec();
        NetworkSpec networkSpec = machineSpec.getNetworkSpec();
        String vmName = vmSpec.getVmName();
        ImmutableMap positionAndDeviceType = ImmutableMap.of((Object)1L, (Object)DeviceType.HardDisk);
        this.ensureMachineHasDesiredBootOrder(vmName, (Map<Long, DeviceType>)positionAndDeviceType);
        this.ensureMachineHasMemory(vmName, vmSpec.getMemory());
        Set<StorageController> controllers = vmSpec.getControllers();
        if (controllers.isEmpty()) {
            throw new IllegalStateException(this.missingIDEControllersMessage(vmSpec));
        }
        StorageController controller = controllers.iterator().next();
        this.ensureMachineHasStorageControllerNamed(vmName, controller);
        this.setupHardDisksForController(vmName, controller);
        this.setupDvdsForController(vmSpec, vmName, controller);
        for (NetworkInterfaceCard networkInterfaceCard : networkSpec.getNetworkInterfaceCards()) {
            new AttachNicToMachine(vmName, this.machineUtils).apply(networkInterfaceCard);
        }
    }

    private void setupDvdsForController(VmSpec vmSpecification, String vmName, StorageController controller) {
        Set<IsoImage> dvds = controller.getIsoImages();
        for (IsoImage dvd : dvds) {
            String dvdSource = dvd.getSourcePath();
            IMedium dvdMedium = ((VirtualBoxManager)this.manager.get()).getVBox().openMedium(dvdSource, DeviceType.DVD, AccessMode.ReadOnly, Boolean.valueOf(vmSpecification.isForceOverwrite()));
            this.ensureMachineDevicesAttached(vmName, dvdMedium, dvd.getDeviceDetails(), controller.getName());
        }
    }

    private void ensureMachineDevicesAttached(String vmName, IMedium medium, DeviceDetails deviceDetails, String controllerName) {
        this.machineUtils.writeLockMachineAndApply(vmName, new AttachMediumToMachineIfNotAlreadyAttached(deviceDetails, medium, controllerName));
    }

    private String missingIDEControllersMessage(VmSpec vmSpecification) {
        return String.format("First controller is not an IDE controller. Please verify that the VM spec is a correct master node: %s", vmSpecification);
    }

    private void setupHardDisksForController(String vmName, StorageController controller) {
        Set<HardDisk> hardDisks = controller.getHardDisks();
        for (HardDisk hardDisk : hardDisks) {
            boolean deleted;
            String sourcePath = hardDisk.getDiskPath();
            if (new File(sourcePath).exists() && !(deleted = new File(sourcePath).delete())) {
                this.logger.error(String.format("File %s could not be deleted.", sourcePath), new Object[0]);
            }
            IMedium medium = new CreateMediumIfNotAlreadyExists(this.manager, this.machineUtils, true).apply(hardDisk);
            this.ensureMachineDevicesAttached(vmName, medium, hardDisk.getDeviceDetails(), controller.getName());
        }
    }

    private void ensureMachineHasDesiredBootOrder(String vmName, Map<Long, DeviceType> positionAndDeviceType) {
        this.machineUtils.writeLockMachineAndApply(vmName, new ApplyBootOrderToMachine(positionAndDeviceType));
    }

    private void ensureMachineHasMemory(String vmName, long memorySize) {
        this.machineUtils.writeLockMachineAndApply(vmName, new ApplyMemoryToMachine(memorySize));
    }

    public void ensureMachineHasStorageControllerNamed(String vmName, StorageController storageController) {
        this.machineUtils.writeLockMachineAndApply(vmName, new AddIDEControllerIfNotExists((StorageController)Preconditions.checkNotNull((Object)storageController, (Object)"storageController can't be null")));
    }
}

