/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.virtualbox.domain.HardDisk;
import org.jclouds.virtualbox.functions.DetachDistroMediumFromMachine;
import org.jclouds.virtualbox.util.MachineUtils;
import org.virtualbox_4_2.AccessMode;
import org.virtualbox_4_2.DeviceType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IMedium;
import org.virtualbox_4_2.IMediumAttachment;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.IVirtualBox;
import org.virtualbox_4_2.VBoxException;
import org.virtualbox_4_2.VirtualBoxManager;
import org.virtualbox_4_2.jaxws.MediumVariant;

@Singleton
public class CreateMediumIfNotAlreadyExists
implements Function<HardDisk, IMedium> {
    private final Supplier<VirtualBoxManager> manager;
    private final MachineUtils machineUtils;
    private final boolean overwriteIfExists;
    public static final Pattern ATTACHED_PATTERN = Pattern.compile(".*is still attached.*: ([-0-9a-f]+) .*");

    @Inject
    public CreateMediumIfNotAlreadyExists(Supplier<VirtualBoxManager> manager, MachineUtils machineUtils, boolean overwriteIfExists) {
        this.manager = manager;
        this.machineUtils = machineUtils;
        this.overwriteIfExists = overwriteIfExists;
    }

    public IMedium apply(HardDisk hardDisk) {
        IVirtualBox vBox = ((VirtualBoxManager)this.manager.get()).getVBox();
        try {
            String diskPath = hardDisk.getDiskPath();
            IMedium medium = vBox.openMedium(diskPath, DeviceType.HardDisk, AccessMode.ReadWrite, Boolean.valueOf(false));
            if (this.overwriteIfExists) {
                try {
                    this.deleteMediumAndBlockUntilComplete(medium);
                }
                catch (VBoxException e) {
                    this.onAlreadyAttachedExceptionDetachOrPropagate(vBox, medium, e);
                }
                return this.createNewMedium(vBox, hardDisk);
            }
            throw new IllegalStateException("Medium for path " + diskPath + " already exists.");
        }
        catch (VBoxException e) {
            if (this.notFoundException(e)) {
                return this.createNewMedium(vBox, hardDisk);
            }
            throw e;
        }
    }

    private void onAlreadyAttachedExceptionDetachOrPropagate(IVirtualBox vBox, final IMedium medium, VBoxException e) {
        Matcher matcher = ATTACHED_PATTERN.matcher(e.getMessage());
        if (!matcher.find()) {
            throw e;
        }
        String machineId = matcher.group(1);
        IMachine immutableMachine = vBox.findMachine(machineId);
        IMediumAttachment mediumAttachment = (IMediumAttachment)Iterables.find((Iterable)immutableMachine.getMediumAttachments(), (Predicate)new Predicate<IMediumAttachment>(){

            public boolean apply(IMediumAttachment in) {
                return in.getMedium().getId().equals(medium.getId());
            }
        });
        this.machineUtils.writeLockMachineAndApply(immutableMachine.getName(), new DetachDistroMediumFromMachine(mediumAttachment.getController(), mediumAttachment.getPort(), mediumAttachment.getDevice()));
        this.deleteMediumAndBlockUntilComplete(medium);
    }

    void deleteMediumAndBlockUntilComplete(IMedium medium) {
        IProgress progress = medium.deleteStorage();
        progress.waitForCompletion(Integer.valueOf(-1));
    }

    private IMedium createNewMedium(IVirtualBox vBox, HardDisk hardDisk) {
        IMedium medium = vBox.createHardDisk(hardDisk.getDiskFormat(), hardDisk.getDiskPath());
        this.createBaseStorage(medium);
        return medium;
    }

    private boolean notFoundException(VBoxException e) {
        return e.getMessage().contains("VirtualBox error: Could not find file for the medium ");
    }

    private void createBaseStorage(IMedium hardDisk) {
        block3: {
            try {
                long size = 0xFFFFFFFCL;
                IProgress storageCreation = hardDisk.createBaseStorage(Long.valueOf(size), Long.valueOf(MediumVariant.STANDARD.ordinal()));
                storageCreation.waitForCompletion(Integer.valueOf(-1));
            }
            catch (VBoxException e) {
                if (this.fileNotFoundException(e)) {
                    hardDisk.deleteStorage();
                }
                if (this.storageAlreadyExists(e)) break block3;
                throw e;
            }
        }
    }

    private boolean fileNotFoundException(VBoxException e) {
        return e.getMessage().contains("VERR_FILE_NOT_FOUND");
    }

    private boolean storageAlreadyExists(VBoxException e) {
        return e.getMessage().contains("VirtualBox error: Storage for the medium ") && e.getMessage().contains("is already created");
    }
}

