/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.logging.Logger;
import org.jclouds.virtualbox.domain.ErrorCode;
import org.jclouds.virtualbox.domain.ExecutionType;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.ISession;
import org.virtualbox_4_2.SessionState;
import org.virtualbox_4_2.VBoxException;
import org.virtualbox_4_2.VirtualBoxManager;

public class LaunchMachineIfNotAlreadyRunning
implements Function<IMachine, ISession> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final VirtualBoxManager manager;
    private final ExecutionType type;
    private final String environment;

    public LaunchMachineIfNotAlreadyRunning(VirtualBoxManager manager, ExecutionType type, String environment) {
        this.manager = manager;
        this.type = type;
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISession apply(IMachine machine) {
        ISession session = this.manager.getSessionObject();
        try {
            IProgress progress = machine.launchVMProcess(session, this.type.stringValue(), this.environment);
            progress.waitForCompletion(Integer.valueOf(-1));
            return session;
        }
        catch (VBoxException e) {
            ErrorCode errorCode = ErrorCode.valueOf(e);
            switch (errorCode) {
                case VBOX_E_INVALID_OBJECT_STATE: {
                    this.logger.warn((Throwable)e, "Could not start machine. Got error code %s from launchMachine(). The machine might already be running.", new Object[]{errorCode});
                    return session;
                }
                default: {
                    Throwables.propagate((Throwable)e);
                    return session;
                }
            }
        }
        finally {
            if (session.getState() == SessionState.Locked) {
                session.unlockMachine();
            }
        }
    }
}

