/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public enum MacAddressToBSD implements Function<String, String>
{
    INSTANCE;


    public String apply(String macAddress) {
        Preconditions.checkArgument((macAddress.length() == 17 ? 1 : 0) != 0);
        return Joiner.on((String)":").join(Iterables.transform((Iterable)Splitter.on((String)":").split((CharSequence)macAddress), (Function)new Function<String, String>(){

            public String apply(String addressPart) {
                if (addressPart.equals("00")) {
                    return "0";
                }
                if (addressPart.startsWith("0")) {
                    return addressPart.substring(1);
                }
                return addressPart;
            }
        }));
    }
}

