/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.cache.AbstractLoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.BuildVersion;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.virtualbox.config.VirtualBoxConstants;
import org.jclouds.virtualbox.domain.HardDisk;
import org.jclouds.virtualbox.domain.IsoSpec;
import org.jclouds.virtualbox.domain.Master;
import org.jclouds.virtualbox.domain.MasterSpec;
import org.jclouds.virtualbox.domain.NetworkAdapter;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;
import org.jclouds.virtualbox.domain.NetworkSpec;
import org.jclouds.virtualbox.domain.StorageController;
import org.jclouds.virtualbox.domain.VmSpec;
import org.jclouds.virtualbox.domain.YamlImage;
import org.jclouds.virtualbox.functions.HardcodedHostToHostNodeMetadata;
import org.jclouds.virtualbox.functions.admin.PreseedCfgServer;
import org.jclouds.virtualbox.predicates.RetryIfSocketNotYetOpen;
import org.jclouds.virtualbox.statements.Md5;
import org.jclouds.virtualbox.util.MachineUtils;
import org.virtualbox_4_2.CleanupMode;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.NetworkAttachmentType;
import org.virtualbox_4_2.StorageBus;
import org.virtualbox_4_2.VBoxException;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class MastersLoadingCache
extends AbstractLoadingCache<Image, Master> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Map<String, Master> masters = Maps.newHashMap();
    private final Function<MasterSpec, IMachine> masterCreatorAndInstaller;
    private final Map<String, YamlImage> imageMapping;
    private final String workingDir;
    private final String isosDir;
    private final Supplier<VirtualBoxManager> manager;
    private final String version;
    private final String preconfigurationUrl;
    private final RunScriptOnNode.Factory runScriptOnNodeFactory;
    private final RetryIfSocketNotYetOpen socketTester;
    private final Supplier<NodeMetadata> host;
    private final Supplier<URI> providerSupplier;
    private final HardcodedHostToHostNodeMetadata hardcodedHostToHostNodeMetadata;

    @Inject
    public MastersLoadingCache(@BuildVersion String version, @Named(value="jclouds.virtualbox.preconfigurationurl") String preconfigurationUrl, @Named(value="jclouds.virtualbox.workingdir") String workingDir, Function<MasterSpec, IMachine> masterLoader, Supplier<Map<Image, YamlImage>> yamlMapper, Supplier<VirtualBoxManager> manager, RunScriptOnNode.Factory runScriptOnNodeFactory, RetryIfSocketNotYetOpen socketTester, Supplier<NodeMetadata> host, @Provider Supplier<URI> providerSupplier, HardcodedHostToHostNodeMetadata hardcodedHostToHostNodeMetadata) {
        this.manager = (Supplier)Preconditions.checkNotNull(manager, (Object)"vboxmanager can't be null");
        this.masterCreatorAndInstaller = masterLoader;
        this.workingDir = workingDir == null ? VirtualBoxConstants.VIRTUALBOX_DEFAULT_DIR : workingDir;
        this.isosDir = workingDir + File.separator + "isos";
        this.imageMapping = Maps.newLinkedHashMap();
        for (Map.Entry entry : ((Map)yamlMapper.get()).entrySet()) {
            this.imageMapping.put(((Image)entry.getKey()).getId(), (YamlImage)entry.getValue());
        }
        this.version = (String)Iterables.get((Iterable)Splitter.on((char)'r').split((CharSequence)Preconditions.checkNotNull((Object)version, (Object)"version")), (int)0);
        this.preconfigurationUrl = preconfigurationUrl;
        this.runScriptOnNodeFactory = (RunScriptOnNode.Factory)Preconditions.checkNotNull((Object)runScriptOnNodeFactory, (Object)"runScriptOnNodeFactory");
        this.socketTester = (RetryIfSocketNotYetOpen)Preconditions.checkNotNull((Object)socketTester, (Object)"socketTester");
        this.socketTester.seconds(3L);
        this.host = (Supplier)Preconditions.checkNotNull(host, (Object)"host");
        this.providerSupplier = (Supplier)Preconditions.checkNotNull(providerSupplier, (Object)"endpoint to virtualbox websrvd is needed");
        this.hardcodedHostToHostNodeMetadata = hardcodedHostToHostNodeMetadata;
    }

    @PostConstruct
    public void createCacheDirStructure() {
        if (!new File(this.workingDir).exists()) {
            new File(this.workingDir, "isos").mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Master get(Image key) throws ExecutionException {
        Master master;
        block10: {
            if (this.masters.containsKey(key.getId())) {
                return this.masters.get(key.getId());
            }
            Preconditions.checkState((!key.getId().contains("-0x0-") ? 1 : 0) != 0, (Object)"master image names cannot contain \"-0x0-\"");
            String vmName = "jclouds-image-0x0-" + key.getId();
            PreseedCfgServer server = new PreseedCfgServer();
            try {
                IMachine masterMachine = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmName);
                master = Master.builder().machine(masterMachine).build();
            }
            catch (VBoxException e) {
                if (MachineUtils.machineNotFoundException(e)) {
                    YamlImage currentImage = (YamlImage)Preconditions.checkNotNull((Object)this.imageMapping.get(key.getId()), (Object)"currentImage");
                    try {
                        URI preseedServer = new URI(this.preconfigurationUrl);
                        if (!this.socketTester.apply(HostAndPort.fromParts((String)preseedServer.getHost(), (int)preseedServer.getPort()))) {
                            server.start(this.preconfigurationUrl, currentImage.preseed_cfg);
                        }
                    }
                    catch (URISyntaxException e1) {
                        this.logger.error("Cannot start the preseed server", new Object[]{e});
                        throw e;
                    }
                    MasterSpec masterSpec = this.buildMasterSpecFromYaml(currentImage, vmName);
                    IMachine masterMachine = (IMachine)this.masterCreatorAndInstaller.apply((Object)masterSpec);
                    master = Master.builder().machine(masterMachine).spec(masterSpec).build();
                    break block10;
                }
                this.logger.error("Problem during master creation", new Object[]{e});
                throw e;
            }
            finally {
                server.stop();
            }
        }
        this.masters.put(key.getId(), master);
        return master;
    }

    private MasterSpec buildMasterSpecFromYaml(YamlImage currentImage, String vmName) throws ExecutionException {
        String guestAdditionsFileName = String.format("VBoxGuestAdditions_%s.iso", this.version);
        String guestAdditionsIso = String.format("%s/%s", this.isosDir, guestAdditionsFileName);
        String guestAdditionsUri = "http://download.virtualbox.org/virtualbox/" + this.version + "/" + guestAdditionsFileName;
        if (!new File(guestAdditionsIso).exists()) {
            this.getFilePathOrDownload(guestAdditionsUri, null);
        }
        String localIsoUrl = (String)Preconditions.checkNotNull((Object)this.getFilePathOrDownload(currentImage.iso, currentImage.iso_md5), (Object)"distro iso");
        String adminDisk = this.workingDir + File.separator + vmName + ".vdi";
        HardDisk hardDisk = HardDisk.builder().diskpath(adminDisk).autoDelete(true).controllerPort(0).deviceSlot(1).build();
        StorageController ideController = StorageController.builder().name("IDE Controller").bus(StorageBus.IDE).attachISO(0, 0, localIsoUrl).attachHardDisk(hardDisk).build();
        VmSpec vmSpecification = VmSpec.builder().id(currentImage.id).name(vmName).memoryMB(512).osTypeId(this.getOsTypeId(currentImage.os_family, currentImage.os_64bit)).controller(ideController).forceOverwrite(true).guestUser(currentImage.username).guestPassword(currentImage.credential).cleanUpMode(CleanupMode.Full).build();
        NetworkAdapter networkAdapter = NetworkAdapter.builder().networkAttachmentType(NetworkAttachmentType.NAT).tcpRedirectRule(((URI)this.providerSupplier.get()).getHost(), 2222, "", 22).build();
        NetworkInterfaceCard networkInterfaceCard = NetworkInterfaceCard.builder().addNetworkAdapter(networkAdapter).slot(0L).build();
        NetworkSpec networkSpec = NetworkSpec.builder().addNIC(networkInterfaceCard).build();
        String installationSequence = currentImage.keystroke_sequence.replace("HOSTNAME", vmSpecification.getVmName());
        return MasterSpec.builder().vm(vmSpecification).iso(IsoSpec.builder().sourcePath(localIsoUrl).installationScript(installationSequence).build()).network(networkSpec).credentials(LoginCredentials.builder().user(currentImage.username).password(currentImage.credential).authenticateSudo(true).build()).build();
    }

    public synchronized Master getIfPresent(Object key) {
        Preconditions.checkArgument((boolean)(key instanceof Image), (Object)"this cache is for entries who's keys are Images");
        Image image = (Image)Image.class.cast(key);
        if (this.masters.containsKey(image.getId())) {
            return this.masters.get(image.getId());
        }
        return null;
    }

    private String getFilePathOrDownload(String httpUrl, String expectedMd5) throws ExecutionException {
        String fileName = httpUrl.substring(httpUrl.lastIndexOf(47) + 1, httpUrl.length());
        URI provider = (URI)this.providerSupplier.get();
        if (!this.socketTester.apply(HostAndPort.fromParts((String)provider.getHost(), (int)provider.getPort()))) {
            throw new RuntimeException("could not connect to virtualbox");
        }
        File file = new File(this.isosDir, fileName);
        ImmutableList statements = new ImmutableList.Builder().add((Object)Statements.saveHttpResponseTo((URI)URI.create(httpUrl), (String)this.isosDir, (String)fileName)).build();
        StatementList statementList = new StatementList((Iterable)statements);
        NodeMetadata hostNode = (NodeMetadata)Preconditions.checkNotNull((Object)this.hardcodedHostToHostNodeMetadata.apply((NodeMetadata)this.host.get()), (Object)"hostNode");
        ListenableFuture future = this.runScriptOnNodeFactory.submit(hostNode, (Statement)statementList, RunScriptOptions.Builder.runAsRoot((boolean)false));
        Futures.getUnchecked((Future)future);
        if (expectedMd5 != null) {
            String filePath = this.isosDir + File.separator + fileName;
            ListenableFuture md5future = this.runScriptOnNodeFactory.submit(hostNode, (Statement)new Md5(filePath), RunScriptOptions.Builder.runAsRoot((boolean)false));
            ExecResponse responseMd5 = (ExecResponse)Futures.getUnchecked((Future)md5future);
            assert (responseMd5.getExitStatus() == 0) : hostNode.getId() + ": " + responseMd5;
            Preconditions.checkNotNull((Object)responseMd5.getOutput(), (Object)"iso_md5 missing");
            String actualMd5 = responseMd5.getOutput().trim();
            Preconditions.checkState((boolean)actualMd5.equals(expectedMd5), (String)"md5 of %s is %s but expected %s", (Object[])new Object[]{filePath, actualMd5, expectedMd5});
        }
        return file.getAbsolutePath();
    }

    private String getOsTypeId(String os_family, boolean os_64bit) {
        String osFamily = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, os_family);
        return os_64bit ? osFamily + "_64" : osFamily;
    }
}

