/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jclouds.virtualbox.settings.KeyboardScancodes;

public class StringToKeyCode
implements Function<String, List<Integer>> {
    public List<Integer> apply(String subsequence) {
        return this.stringToKeycode(subsequence);
    }

    private List<Integer> stringToKeycode(String s) {
        if (this.containsSpecialCharacter(s)) {
            return this.transformSpecialCharIntoKeycodes(s);
        }
        return this.transformStandardCharacterIntoKeycodes(s);
    }

    private List<Integer> transformStandardCharacterIntoKeycodes(String s) {
        ArrayList values = Lists.newArrayList();
        for (String digit : Splitter.fixedLength((int)1).split((CharSequence)s)) {
            Collection hex = KeyboardScancodes.NORMAL_KEYBOARD_BUTTON_MAP_LIST.get((Object)digit);
            if (hex == null) continue;
            values.addAll(hex);
        }
        values.addAll(KeyboardScancodes.SPECIAL_KEYBOARD_BUTTON_MAP_LIST.get((Object)"<Spacebar>"));
        return values;
    }

    private List<Integer> transformSpecialCharIntoKeycodes(String s) {
        ArrayList values = Lists.newArrayList();
        for (String special : s.split("<")) {
            Collection value = KeyboardScancodes.SPECIAL_KEYBOARD_BUTTON_MAP_LIST.get((Object)("<" + special));
            if (value == null) continue;
            values.addAll(value);
        }
        return values;
    }

    private boolean containsSpecialCharacter(String s) {
        return s.startsWith("<");
    }
}

