/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.util.Strings2;

public class YamlImagesFromFileConfig
implements Supplier<String> {
    private String yamlFilePath;

    @Inject
    public YamlImagesFromFileConfig(@Named(value="jclouds.virtualbox.image.descriptor.yaml") String yamlFilePath) {
        this.yamlFilePath = yamlFilePath;
    }

    public String get() {
        try {
            File yamlFile = new File(this.yamlFilePath);
            String yamlDesc = null;
            yamlDesc = !yamlFile.exists() ? Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/default-images.yaml")) : Files.toString((File)yamlFile, (Charset)Charsets.UTF_8);
            Preconditions.checkNotNull((Object)yamlDesc, (Object)"yaml descriptor");
            return yamlDesc;
        }
        catch (IOException e) {
            throw new RuntimeException("error reading yaml file");
        }
    }
}

