/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions.admin;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.rest.HttpClient;
import org.jclouds.util.Closeables2;

public class FileDownloadFromURI
implements Function<URI, File> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final HttpClient client;
    private final String isosDir;

    @Inject
    public FileDownloadFromURI(HttpClient client, @Named(value="jclouds.virtualbox.workingdir") String workingDir) {
        this.client = client;
        this.isosDir = workingDir + File.separator + "isos";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File apply(@Nullable URI input) {
        File file = new File(this.isosDir, new File(input.getPath()).getName());
        try {
            if (file.exists()) {
                this.logger.debug("File %s already exists. Skipping download", new Object[]{file.getPath()});
                return file;
            }
            InputStream inputStream = this.client.get(input);
            Preconditions.checkNotNull((Object)inputStream, (String)"%s not found", (Object[])new Object[]{input});
            try {
                Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).writeFrom(inputStream);
                File file2 = file;
                return file2;
            }
            catch (FileNotFoundException e) {
                this.logger.error((Throwable)e, "File %s could not be found", new Object[]{file.getPath()});
                return null;
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, "Error when downloading file %s", new Object[]{input.toString()});
                return null;
            }
            finally {
                Closeables2.closeQuietly((Closeable)inputStream);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

