/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.functions.admin;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.net.URI;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.virtualbox.functions.HardcodedHostToHostNodeMetadata;
import org.jclouds.virtualbox.predicates.RetryIfSocketNotYetOpen;
import org.virtualbox_4_2.SessionState;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class StartVBoxIfNotAlreadyRunning
implements Supplier<VirtualBoxManager> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final RunScriptOnNode.Factory runScriptOnNodeFactory;
    private final RetryIfSocketNotYetOpen socketTester;
    private final Supplier<NodeMetadata> host;
    private final Supplier<URI> providerSupplier;
    private final Function<Supplier<NodeMetadata>, VirtualBoxManager> managerForNode;
    private transient VirtualBoxManager manager;
    private final HardcodedHostToHostNodeMetadata hardcodedHostToHostNodeMetadata;

    @Inject
    public StartVBoxIfNotAlreadyRunning(Function<Supplier<NodeMetadata>, VirtualBoxManager> managerForNode, RunScriptOnNode.Factory runScriptOnNodeFactory, RetryIfSocketNotYetOpen socketTester, Supplier<NodeMetadata> host, @Provider Supplier<URI> providerSupplier, HardcodedHostToHostNodeMetadata hardcodedHostToHostNodeMetadata) {
        this.runScriptOnNodeFactory = (RunScriptOnNode.Factory)Preconditions.checkNotNull((Object)runScriptOnNodeFactory, (Object)"runScriptOnNodeFactory");
        this.socketTester = (RetryIfSocketNotYetOpen)Preconditions.checkNotNull((Object)socketTester, (Object)"socketTester");
        this.socketTester.seconds(3L);
        this.host = (Supplier)Preconditions.checkNotNull(host, (Object)"host");
        this.providerSupplier = (Supplier)Preconditions.checkNotNull(providerSupplier, (Object)"endpoint to virtualbox websrvd is needed");
        this.managerForNode = (Function)Preconditions.checkNotNull(managerForNode, (Object)"managerForNode");
        this.hardcodedHostToHostNodeMetadata = hardcodedHostToHostNodeMetadata;
    }

    @PostConstruct
    public void start() {
        URI provider = (URI)this.providerSupplier.get();
        NodeMetadata hostNodeMetadata = this.hardcodedHostToHostNodeMetadata.apply((NodeMetadata)this.host.get());
        if (!this.socketTester.apply(HostAndPort.fromParts((String)provider.getHost(), (int)provider.getPort()))) {
            this.logger.debug("disabling password access", new Object[0]);
            this.runScriptOnNodeFactory.create(hostNodeMetadata, Statements.exec((String)"VBoxManage setproperty websrvauthlibrary null"), RunScriptOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false)).init().call();
            this.logger.debug(">> starting vboxwebsrv", new Object[0]);
            String vboxwebsrv = "vboxwebsrv -t0 -v -b -H " + ((URI)this.providerSupplier.get()).getHost();
            this.runScriptOnNodeFactory.create(hostNodeMetadata, Statements.exec((String)vboxwebsrv), RunScriptOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false).blockOnComplete(false).nameTask("vboxwebsrv")).init().call();
            if (!this.socketTester.apply(HostAndPort.fromParts((String)provider.getHost(), (int)provider.getPort()))) {
                throw new UncheckedTimeoutException(String.format("could not connect to virtualbox at %s", provider));
            }
        }
        this.manager = (VirtualBoxManager)this.managerForNode.apply(this.host);
        this.manager.connect(provider.toASCIIString(), "", "");
        if (this.logger.isDebugEnabled() && this.manager.getSessionObject().getState() != SessionState.Unlocked) {
            this.logger.warn("manager is not in unlocked state " + this.manager.getSessionObject().getState(), new Object[0]);
        }
    }

    public void cleanUpHost() {
        URI provider = (URI)this.providerSupplier.get();
        NodeMetadata hostNodeMetadata = this.hardcodedHostToHostNodeMetadata.apply((NodeMetadata)this.host.get());
        ImmutableList statements = new ImmutableList.Builder().add((Object)Statements.findPid((String)"vboxwebsrv")).add((Object)Statements.kill()).build();
        StatementList statementList = new StatementList((Iterable)statements);
        if (this.socketTester.apply(HostAndPort.fromParts((String)provider.getHost(), (int)provider.getPort()))) {
            this.logger.debug(String.format("shutting down previously started vboxwewbsrv at %s", provider), new Object[0]);
            ExecResponse execResponse = this.runScriptOnNodeFactory.create(hostNodeMetadata, (Statement)statementList, RunScriptOptions.Builder.runAsRoot((boolean)false)).init().call();
            if (execResponse.getExitStatus() != 0) {
                throw new RuntimeException(String.format("Cannot shutdown a running vboxwebsrv at %s. ExecResponse: %s", provider, execResponse));
            }
        }
    }

    public VirtualBoxManager get() {
        Preconditions.checkState((this.manager != null ? 1 : 0) != 0, (Object)"VirtualBoxManager is not initialised");
        return this.manager;
    }
}

