/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.predicates;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.jclouds.virtualbox.predicates.IMediumPredicates;
import org.jclouds.virtualbox.util.IMediumAttachments;
import org.virtualbox_4_2.DeviceType;
import org.virtualbox_4_2.IMachine;

public class IMachinePredicates {
    public static Predicate<IMachine> isLinkedClone() {
        return IsLinkedClone.INSTANCE;
    }

    static enum IsLinkedClone implements Predicate<IMachine>
    {
        INSTANCE;


        public boolean apply(IMachine machine) {
            Iterable mediumsOnMachine = Iterables.transform((Iterable)machine.getMediumAttachments(), IMediumAttachments.toMedium());
            return Iterables.any((Iterable)mediumsOnMachine, (Predicate)Predicates.and((Predicate[])new Predicate[]{IMediumPredicates.deviceTypeEquals(DeviceType.HardDisk), IMediumPredicates.hasParent(), IMediumPredicates.machineIdsContain(machine.getId())}));
        }

        public String toString() {
            return "isLinkedClone()";
        }
    }
}

