/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.virtualbox_4_2.DeviceType;
import org.virtualbox_4_2.IMedium;

public class IMediumPredicates {
    public static Predicate<IMedium> deviceTypeEquals(DeviceType deviceType) {
        return new DeviceTypeEquals(deviceType);
    }

    public static Predicate<IMedium> hasParent() {
        return HasParent.INSTANCE;
    }

    public static Predicate<IMedium> machineIdsContain(String id) {
        return new MachineIdsContain(id);
    }

    public static class MachineIdsContain
    implements Predicate<IMedium> {
        private final String id;

        public MachineIdsContain(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        }

        public boolean apply(IMedium arg0) {
            return Iterables.any((Iterable)arg0.getMachineIds(), (Predicate)Predicates.equalTo((Object)this.id));
        }

        public String toString() {
            return "machineIdsContain(" + this.id + ")";
        }
    }

    public static enum HasParent implements Predicate<IMedium>
    {
        INSTANCE;


        public boolean apply(IMedium arg0) {
            return arg0.getParent() != null;
        }

        public String toString() {
            return "hasParent()";
        }
    }

    public static class DeviceTypeEquals
    implements Predicate<IMedium> {
        private final DeviceType deviceType;

        public DeviceTypeEquals(DeviceType deviceType) {
            this.deviceType = (DeviceType)Preconditions.checkNotNull((Object)deviceType, (Object)"deviceType");
        }

        public boolean apply(IMedium arg0) {
            return this.deviceType.equals((Object)arg0.getDeviceType());
        }

        public String toString() {
            return "deviceTypeEquals(" + this.deviceType + ")";
        }
    }
}

