/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.predicates;

import com.google.common.base.Predicate;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshException;

public class SshAvailable
implements Predicate<String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ComputeServiceContext context;

    public SshAvailable(ComputeServiceContext context) {
        this.context = context;
    }

    public boolean apply(String nodeId) {
        boolean sshDaemonIsRunning = false;
        try {
            if (this.context.getComputeService().runScriptOnNode(nodeId, "id", RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false)).getExitStatus() == 0) {
                this.logger.debug("Got response from ssh daemon running on %s", new Object[]{nodeId});
                sshDaemonIsRunning = true;
            }
        }
        catch (SshException e) {
            this.logger.debug("No response from ssh daemon running on %s", new Object[]{nodeId});
            return sshDaemonIsRunning;
        }
        return sshDaemonIsRunning;
    }

    public String toString() {
        return "sshAvailable()";
    }
}

