/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.statements;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;

public class EnableNetworkInterface
implements Statement {
    private final StatementList statements;

    public EnableNetworkInterface(NetworkInterfaceCard networkInterfaceCard) {
        int slot = (int)networkInterfaceCard.getSlot();
        String iface = null;
        switch (slot) {
            case 0: {
                iface = "eth0";
                break;
            }
            case 1: {
                iface = "eth1";
                break;
            }
            case 2: {
                iface = "eth2";
                break;
            }
            case 3: {
                iface = "eth3";
                break;
            }
            default: {
                throw new IllegalArgumentException("slot must be 0,1,2,3 (was: " + slot + ")");
            }
        }
        this.statements = new StatementList(this.getStatements(iface));
    }

    private List<Statement> getStatements(String iface) {
        ArrayList statements = Lists.newArrayList();
        statements.add(Statements.exec((String)String.format("echo auto %s >> /etc/network/interfaces", iface)));
        statements.add(Statements.exec((String)String.format("echo iface %s inet dhcp >> /etc/network/interfaces", iface)));
        statements.add(Statements.exec((String)"/etc/init.d/networking restart"));
        return statements;
    }

    public Iterable<String> functionDependencies(OsFamily family) {
        return this.statements.functionDependencies(family);
    }

    public String render(OsFamily family) {
        if (Preconditions.checkNotNull((Object)family, (Object)"family") == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        return this.statements.render(family);
    }
}

