/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.statements;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.util.Utils;
import org.jclouds.virtualbox.functions.MacAddressToBSD;

public class GetIPAddressFromMAC
implements Statement {
    public static final Map<OsFamily, String> OS_TO_ARP = ImmutableMap.of((Object)OsFamily.UNIX, (Object)"MAC={macAddress} && [[ `uname -s` = \"Darwin\" ]] && MAC={macAddressBsd}\n arp -an | grep $MAC\n", (Object)OsFamily.WINDOWS, (Object)"set MAC={macAddress} arp -a | Findstr %MAC%");
    private String macAddress;
    private String macAddressBsd;

    public GetIPAddressFromMAC(String macAddress) {
        this(Joiner.on((String)":").join(Splitter.fixedLength((int)2).split((CharSequence)macAddress)).toLowerCase(), MacAddressToBSD.INSTANCE.apply(Joiner.on((String)":").join(Splitter.fixedLength((int)2).split((CharSequence)macAddress)).toLowerCase()));
    }

    public GetIPAddressFromMAC(String macAddress, String macAddressBsd) {
        Preconditions.checkNotNull((Object)macAddress, (Object)"macAddress");
        Preconditions.checkArgument((macAddress.length() == 17 ? 1 : 0) != 0);
        this.macAddress = macAddress;
        Preconditions.checkNotNull((Object)macAddressBsd, (Object)"macAddressBsd");
        this.macAddressBsd = macAddressBsd;
    }

    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    public String render(OsFamily family) {
        StringBuilder arp = new StringBuilder();
        arp.append(Utils.replaceTokens((String)OS_TO_ARP.get(family), (Map)ImmutableMap.of((Object)"macAddress", (Object)this.macAddress, (Object)"macAddressBsd", (Object)this.macAddressBsd)));
        return arp.toString();
    }
}

