/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.statements;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.util.Utils;

public class ScanNetworkWithPing
implements Statement {
    public static final Map<OsFamily, String> OS_TO_PING = ImmutableMap.of((Object)OsFamily.UNIX, (Object)"for i in {1..254} ; do ping -c 1 -t 1 {network}.$i & done", (Object)OsFamily.WINDOWS, (Object)"TODO");
    private String network;

    public ScanNetworkWithPing(String network) {
        this.network = (String)Preconditions.checkNotNull((Object)network, (Object)"network");
    }

    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    public String render(OsFamily family) {
        this.network = this.network.substring(0, this.network.lastIndexOf("."));
        StringBuilder arp = new StringBuilder();
        arp.append(Utils.replaceTokens((String)OS_TO_PING.get(family), (Map)ImmutableMap.of((Object)"network", (Object)this.network)));
        return arp.toString();
    }
}

