/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.statements;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;

public class SetHostname
implements Statement {
    private final String publicIpAddress;

    public SetHostname(String publicIpAddress) {
        this.publicIpAddress = (String)Preconditions.checkNotNull((Object)publicIpAddress, (Object)"publicIpAddress");
    }

    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    public String render(OsFamily family) {
        if (Preconditions.checkNotNull((Object)family, (Object)"family") == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        return String.format("sudo hostname %s", this.publicIpAddress);
    }
}

