/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.statements;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.virtualbox.domain.NetworkInterfaceCard;

public class SetIpAddress
implements Statement {
    private String script;

    public SetIpAddress(NetworkInterfaceCard networkInterfaceCard) {
        String ipAddress = networkInterfaceCard.getNetworkAdapter().getStaticIp();
        Preconditions.checkNotNull((Object)ipAddress, (Object)"ip address");
        int slot = (int)networkInterfaceCard.getSlot();
        String iface = null;
        switch (slot) {
            case 0: {
                iface = "eth0";
                break;
            }
            case 1: {
                iface = "eth1";
                break;
            }
            case 2: {
                iface = "eth2";
                break;
            }
            case 3: {
                iface = "eth3";
                break;
            }
            default: {
                throw new IllegalArgumentException("slot must be 0,1,2,3 (was: " + slot + ")");
            }
        }
        this.script = String.format("ifconfig %s %s;", iface, ipAddress);
    }

    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    public String render(OsFamily family) {
        if (Preconditions.checkNotNull((Object)family, (Object)"family") == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        return this.script;
    }
}

