/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;
import org.jclouds.virtualbox.domain.ExecutionType;
import org.jclouds.virtualbox.functions.LaunchMachineIfNotAlreadyRunning;
import org.jclouds.virtualbox.util.MachineUtils;
import org.virtualbox_4_2.AdditionsFacilityStatus;
import org.virtualbox_4_2.AdditionsFacilityType;
import org.virtualbox_4_2.AdditionsRunLevelType;
import org.virtualbox_4_2.IAdditionsFacility;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.IProgress;
import org.virtualbox_4_2.ISession;
import org.virtualbox_4_2.IVirtualBox;
import org.virtualbox_4_2.LockType;
import org.virtualbox_4_2.MachineState;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class MachineController {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<VirtualBoxManager> manager;
    private final MachineUtils machineUtils;
    private final ExecutionType executionType;

    @Inject
    public MachineController(Supplier<VirtualBoxManager> manager, MachineUtils machineUtils, ExecutionType executionType) {
        this.manager = manager;
        this.machineUtils = machineUtils;
        this.executionType = executionType;
    }

    public ISession ensureMachineIsLaunched(String vmName) {
        ISession session = null;
        IMachine machine = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmName);
        while (!machine.getState().equals((Object)MachineState.Running)) {
            try {
                session = this.machineUtils.applyForMachine(vmName, new LaunchMachineIfNotAlreadyRunning((VirtualBoxManager)this.manager.get(), this.executionType, ""));
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("org.virtualbox_4_2.VBoxException: VirtualBox error: The given session is busy (0x80BB0007)")) {
                    throw e;
                }
                if (e.getMessage().contains("VirtualBox error: The object is not ready")) continue;
                throw e;
            }
        }
        String guestAdditionsInstalled = this.machineUtils.sharedLockMachineAndApplyToSession(vmName, new Function<ISession, String>(){

            public String apply(ISession session) {
                Predicates2.retry((Predicate)new FacilitiesPredicate(session), (long)15L, (long)3L, (TimeUnit)TimeUnit.SECONDS).apply((Object)4);
                String guestAdditionsInstalled = session.getConsole().getGuest().getAdditionsVersion();
                return guestAdditionsInstalled;
            }
        });
        if (!Strings.nullToEmpty((String)guestAdditionsInstalled).isEmpty()) {
            this.logger.debug("<< guest additions(%s) installed on vm(%s)", new Object[]{guestAdditionsInstalled, vmName});
            this.waitVBoxServiceIsActive(vmName);
        } else {
            this.logger.debug("<< guest additions not available on(%s)", new Object[]{vmName});
        }
        return (ISession)Preconditions.checkNotNull((Object)session, (Object)"session");
    }

    public ISession ensureMachineHasPowerDown(String vmName) {
        ISession session = this.machineUtils.sharedLockMachineAndApplyToSession(vmName, new Function<ISession, ISession>(){

            public ISession apply(ISession session) {
                IProgress powerdownIProgress = session.getConsole().powerDown();
                powerdownIProgress.waitForCompletion(Integer.valueOf(-1));
                return session;
            }
        });
        return (ISession)Preconditions.checkNotNull((Object)session, (Object)"session");
    }

    public ISession ensureMachineIsShutdown(String vmName) {
        ISession session = this.machineUtils.sharedLockMachineAndApplyToSession(vmName, new Function<ISession, ISession>(){

            public ISession apply(ISession session) {
                session.getConsole().powerButton();
                return session;
            }
        });
        Preconditions.checkState((boolean)Predicates2.retry((Predicate)new MachineStatePredicate(((VirtualBoxManager)this.manager.get()).getVBox(), vmName), (long)15L, (long)3L, (TimeUnit)TimeUnit.SECONDS).apply((Object)MachineState.PoweredOff), (String)"vm(%s) is not shutdown correctly", (Object[])new Object[]{vmName});
        return (ISession)Preconditions.checkNotNull((Object)session, (Object)"session");
    }

    public void ensureMachineIsPaused(String vmName) {
        while (!((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmName).getState().equals((Object)MachineState.Paused)) {
            try {
                this.machineUtils.lockSessionOnMachineAndApply(vmName, LockType.Shared, new Function<ISession, Void>(){

                    public Void apply(ISession session) {
                        session.getConsole().pause();
                        return null;
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("Invalid machine state: Paused")) {
                    return;
                }
                if (e.getMessage().contains("VirtualBox error: The object is not ready")) continue;
                throw e;
            }
        }
    }

    public void ensureMachineIsResumed(String vmName) {
        while (!((VirtualBoxManager)this.manager.get()).getVBox().findMachine(vmName).getState().equals((Object)MachineState.Running)) {
            try {
                this.machineUtils.lockSessionOnMachineAndApply(vmName, LockType.Shared, new Function<ISession, Void>(){

                    public Void apply(ISession session) {
                        session.getConsole().resume();
                        return null;
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("Invalid machine state: Resumed")) {
                    return;
                }
                if (e.getMessage().contains("VirtualBox error: The object is not ready")) continue;
                throw e;
            }
        }
    }

    private void waitVBoxServiceIsActive(final String vmName) {
        this.machineUtils.sharedLockMachineAndApplyToSession(vmName, new Function<ISession, Void>(){

            public Void apply(ISession session) {
                Preconditions.checkState((boolean)Predicates2.retry((Predicate)new AdditionsStatusPredicate(session), (long)10L, (long)2L, (TimeUnit)TimeUnit.SECONDS).apply((Object)AdditionsRunLevelType.Userland), (String)"timed out waiting for additionsRunLevelType to be %s", (Object[])new Object[]{AdditionsRunLevelType.Userland});
                Preconditions.checkState((boolean)Predicates2.retry((Predicate)new FacilitiesPredicate(session), (long)15L, (long)3L, (TimeUnit)TimeUnit.SECONDS).apply((Object)4), (Object)"timed out waiting for 4 running facilities");
                Optional vboxServiceFacility = Optional.absent();
                while (!vboxServiceFacility.isPresent()) {
                    List facilities = session.getConsole().getGuest().getFacilities();
                    vboxServiceFacility = Iterables.tryFind((Iterable)facilities, (Predicate)new Predicate<IAdditionsFacility>(){

                        public boolean apply(IAdditionsFacility additionsFacility) {
                            return additionsFacility.getType().equals((Object)AdditionsFacilityType.VBoxService) && additionsFacility.getStatus().equals((Object)AdditionsFacilityStatus.Active);
                        }
                    });
                }
                MachineController.this.logger.debug("<< virtualbox service ready on vm(%s)", new Object[]{vmName});
                return null;
            }
        });
    }

    private static class MachineStatePredicate
    implements Predicate<MachineState> {
        private final IVirtualBox virtualBox;
        private final String vmName;

        MachineStatePredicate(IVirtualBox virtualBox, String vmName) {
            this.virtualBox = virtualBox;
            this.vmName = vmName;
        }

        public boolean apply(MachineState input) {
            MachineState state = this.virtualBox.findMachine(this.vmName).getState();
            return state.equals((Object)input);
        }
    }

    private static class FacilitiesPredicate
    implements Predicate<Integer> {
        private final ISession session;

        FacilitiesPredicate(ISession session) {
            this.session = session;
        }

        public boolean apply(Integer input) {
            return this.session.getConsole().getGuest().getFacilities().size() == input.intValue();
        }
    }

    private static class AdditionsStatusPredicate
    implements Predicate<AdditionsRunLevelType> {
        private final ISession session;

        AdditionsStatusPredicate(ISession session) {
            this.session = session;
        }

        public boolean apply(AdditionsRunLevelType input) {
            return this.session.getConsole().getGuest().getAdditionsStatus(input);
        }
    }
}

