/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;

public final class MachineNameOrIdAndNicSlot {
    private static final String SEPARATOR = ":";
    private final String machineNameOrId;
    private final long slot;

    private MachineNameOrIdAndNicSlot(String machineNameOrId, long slot) {
        this.machineNameOrId = machineNameOrId;
        this.slot = slot;
    }

    public String getMachineNameOrId() {
        return this.machineNameOrId;
    }

    public boolean hasSlot() {
        return this.slot >= 0L;
    }

    public long getSlot() {
        Preconditions.checkState((boolean)this.hasSlot());
        return this.slot;
    }

    public String getSlotText() {
        Preconditions.checkState((boolean)this.hasSlot());
        return String.valueOf(this.slot);
    }

    public static MachineNameOrIdAndNicSlot fromParts(String machineNameOrId, long slot) {
        Preconditions.checkArgument((boolean)MachineNameOrIdAndNicSlot.isValidSlot(slot));
        return new MachineNameOrIdAndNicSlot((String)Preconditions.checkNotNull((Object)machineNameOrId, (Object)"machineNameOrId"), slot);
    }

    public static MachineNameOrIdAndNicSlot fromString(String machineNameOrIdAndNicSlotString) {
        Iterable splittedString = Splitter.on((String)SEPARATOR).split((CharSequence)machineNameOrIdAndNicSlotString);
        Preconditions.checkState((Iterables.size((Iterable)splittedString) == 2 ? 1 : 0) != 0);
        String machineNameOrId = Strings.nullToEmpty((String)((String)Iterables.get((Iterable)splittedString, (int)0)));
        String nicSlotString = Strings.nullToEmpty((String)((String)Iterables.get((Iterable)splittedString, (int)1)));
        Preconditions.checkArgument((!nicSlotString.startsWith("+") ? 1 : 0) != 0, (String)"Unparseable slot number: %s", (Object[])new Object[]{nicSlotString});
        try {
            long slot = Long.parseLong(nicSlotString);
            Preconditions.checkArgument((boolean)MachineNameOrIdAndNicSlot.isValidSlot(slot), (String)"Slot number out of range: %s", (Object[])new Object[]{nicSlotString});
            return new MachineNameOrIdAndNicSlot(machineNameOrId, slot);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unparseable slot number: " + nicSlotString);
        }
    }

    public MachineNameOrIdAndNicSlot withDefaultSlot(int defaultSlot) {
        Preconditions.checkArgument((boolean)MachineNameOrIdAndNicSlot.isValidSlot(defaultSlot));
        if (this.hasSlot() || this.slot == (long)defaultSlot) {
            return this;
        }
        return new MachineNameOrIdAndNicSlot(this.machineNameOrId, defaultSlot);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MachineNameOrIdAndNicSlot) {
            MachineNameOrIdAndNicSlot that = (MachineNameOrIdAndNicSlot)other;
            return Objects.equal((Object)this.machineNameOrId, (Object)that.machineNameOrId) && this.slot == that.slot;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.machineNameOrId, this.slot});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("machineNameOrId", (Object)this.machineNameOrId).add("nicSlot", this.slot).toString();
    }

    private static boolean isValidSlot(long slot) {
        return slot >= 0L && slot <= 3L;
    }
}

