/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.virtualbox.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Inject;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.util.Predicates2;
import org.jclouds.util.Throwables2;
import org.virtualbox_4_2.IMachine;
import org.virtualbox_4_2.ISession;
import org.virtualbox_4_2.LockType;
import org.virtualbox_4_2.SessionState;
import org.virtualbox_4_2.VBoxException;
import org.virtualbox_4_2.VirtualBoxManager;

@Singleton
public class MachineUtils {
    public static final String IP_V4_ADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<VirtualBoxManager> manager;
    private final RunScriptOnNode.Factory scriptRunner;

    @Inject
    public MachineUtils(Supplier<VirtualBoxManager> manager, RunScriptOnNode.Factory scriptRunner) {
        this.manager = manager;
        this.scriptRunner = scriptRunner;
    }

    public ListenableFuture<ExecResponse> runScriptOnNode(NodeMetadata metadata, Statement statement, RunScriptOptions options) {
        return this.scriptRunner.submit(metadata, statement, options);
    }

    public <T> T writeLockMachineAndApply(String machineId, final Function<IMachine, T> function) {
        return this.lockSessionOnMachineAndApply(machineId, LockType.Write, new Function<ISession, T>(){

            public T apply(ISession session) {
                return function.apply((Object)session.getMachine());
            }

            public String toString() {
                return function.toString();
            }
        });
    }

    public <T> T writeLockMachineAndApplyToSession(String machineId, Function<ISession, T> function) {
        return this.lockSessionOnMachineAndApply(machineId, LockType.Write, function);
    }

    public <T> T sharedLockMachineAndApply(String machineId, final Function<IMachine, T> function) {
        return this.lockSessionOnMachineAndApply(machineId, LockType.Shared, new Function<ISession, T>(){

            public T apply(ISession session) {
                return function.apply((Object)session.getMachine());
            }

            public String toString() {
                return function.toString();
            }
        });
    }

    public <T> T sharedLockMachineAndApplyToSession(String machineId, Function<ISession, T> function) {
        return this.lockSessionOnMachineAndApply(machineId, LockType.Shared, function);
    }

    protected <T> T lockSessionOnMachineAndApply(String machineId, LockType type, Function<ISession, T> function) {
        int retries = 15;
        ISession session = (ISession)Preconditions.checkNotNull((Object)this.lockSession(machineId, type, retries), (Object)"session");
        try {
            Object object = function.apply((Object)session);
            return (T)object;
        }
        catch (VBoxException e) {
            throw new RuntimeException(String.format("error applying %s to %s with %s lock: %s", function, machineId, type, e.getMessage()), e);
        }
        finally {
            if (type == LockType.Shared) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            if (session.getState().equals((Object)SessionState.Locked)) {
                session.unlockMachine();
            }
            if (!session.getState().equals((Object)SessionState.Unlocked)) {
                this.checkSessionIsUnlocked(session, 5, 3L, TimeUnit.SECONDS);
            }
        }
    }

    private ISession lockSession(String machineId, LockType type, int retries) {
        ISession session;
        int count = 0;
        IMachine immutableMachine = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(machineId);
        while (true) {
            try {
                session = ((VirtualBoxManager)this.manager.get()).getSessionObject();
                immutableMachine.lockMachine(session, type);
            }
            catch (VBoxException e) {
                VBoxException vbex = (VBoxException)Throwables2.getFirstThrowableOfType((Throwable)e, VBoxException.class);
                if (vbex != null && MachineUtils.machineNotFoundException(vbex)) {
                    return null;
                }
                this.logger.debug("Could not lock machine (try %d of %d). Error: %s", new Object[]{++count, retries, e.getMessage()});
                if (count == retries) {
                    throw new RuntimeException(String.format("error locking %s with %s lock: %s", machineId, type, e.getMessage()), e);
                }
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
        Preconditions.checkState((boolean)session.getState().equals((Object)SessionState.Locked));
        return (ISession)Preconditions.checkNotNull((Object)session, (Object)"session");
    }

    public <T> T applyForMachine(String machineId, final Function<IMachine, T> function) {
        IMachine immutableMachine = ((VirtualBoxManager)this.manager.get()).getVBox().findMachine(machineId);
        return new Function<IMachine, T>(){

            public T apply(IMachine machine) {
                return function.apply((Object)machine);
            }

            public String toString() {
                return function.toString();
            }
        }.apply(immutableMachine);
    }

    public static boolean machineNotFoundException(VBoxException e) {
        return e.getMessage().contains("VirtualBox error: Could not find a registered machine named ") || e.getMessage().contains("Could not find a registered machine with UUID {");
    }

    private void checkSessionIsUnlocked(ISession session, int attempts, long period, TimeUnit timeUnit) {
        Preconditions.checkState((boolean)Predicates2.retry((Predicate)new SessionStatePredicate(session), (long)((long)attempts * period), (long)period, (TimeUnit)timeUnit).apply((Object)SessionState.Unlocked), (String)"timed out or number of retries(%s) reached waiting for session to be unlocked", (Object[])new Object[]{attempts});
    }

    private static class SessionStatePredicate
    implements Predicate<SessionState> {
        private final ISession session;

        SessionStatePredicate(ISession session) {
            this.session = session;
        }

        public boolean apply(SessionState input) {
            return this.session.getState().equals((Object)input);
        }
    }
}

