/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.apache.kafka.connect.transforms.util.SimpleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Cast<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger log = LoggerFactory.getLogger(Cast.class);
    public static final String OVERVIEW_DOC = "Cast fields or the entire key or value to a specific type, e.g. to force an integer field to a smaller width. Cast from integers, floats, boolean and string to any other type, and cast binary to string (base64 encoded).<p/>Use the concrete transformation type designed for the record key (<code>" + Key.class.getName() + "</code>) or value (<code>" + Value.class.getName() + "</code>).";
    public static final String SPEC_CONFIG = "spec";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("spec", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, new ConfigDef.Validator(){

        public void ensureValid(String name, Object valueObject) {
            List value = (List)valueObject;
            if (value == null || value.isEmpty()) {
                throw new ConfigException("Must specify at least one field to cast.");
            }
            Cast.parseFieldTypes(value);
        }

        public String toString() {
            return "list of colon-delimited pairs, e.g. <code>foo:bar,abc:xyz</code>";
        }
    }, ConfigDef.Importance.HIGH, "List of fields and the type to cast them to of the form field1:type,field2:type to cast fields of Maps or Structs. A single type to cast the entire value. Valid types are int8, int16, int32, int64, float32, float64, boolean, and string. Note that binary fields can only be cast to string.");
    private static final String PURPOSE = "cast types";
    private static final Set<Schema.Type> SUPPORTED_CAST_INPUT_TYPES = EnumSet.of(Schema.Type.INT8, new Schema.Type[]{Schema.Type.INT16, Schema.Type.INT32, Schema.Type.INT64, Schema.Type.FLOAT32, Schema.Type.FLOAT64, Schema.Type.BOOLEAN, Schema.Type.STRING, Schema.Type.BYTES});
    private static final Set<Schema.Type> SUPPORTED_CAST_OUTPUT_TYPES = EnumSet.of(Schema.Type.INT8, new Schema.Type[]{Schema.Type.INT16, Schema.Type.INT32, Schema.Type.INT64, Schema.Type.FLOAT32, Schema.Type.FLOAT64, Schema.Type.BOOLEAN, Schema.Type.STRING});
    private static final String WHOLE_VALUE_CAST = null;
    private Map<String, Schema.Type> casts;
    private Schema.Type wholeValueCastType;
    private Cache<Schema, Schema> schemaUpdateCache;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.casts = Cast.parseFieldTypes(config.getList(SPEC_CONFIG));
        this.wholeValueCastType = this.casts.get(WHOLE_VALUE_CAST);
        this.schemaUpdateCache = new SynchronizedCache((Cache)new LRUCache(16));
    }

    public R apply(R record) {
        if (this.operatingValue(record) == null) {
            return record;
        }
        if (this.operatingSchema(record) == null) {
            return this.applySchemaless(record);
        }
        return this.applyWithSchema(record);
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    private R applySchemaless(R record) {
        if (this.wholeValueCastType != null) {
            return this.newRecord(record, null, Cast.castValueToType(null, this.operatingValue(record), this.wholeValueCastType));
        }
        Map<String, Object> value = Requirements.requireMap(this.operatingValue(record), PURPOSE);
        HashMap<String, Object> updatedValue = new HashMap<String, Object>(value);
        for (Map.Entry<String, Schema.Type> fieldSpec : this.casts.entrySet()) {
            String field = fieldSpec.getKey();
            updatedValue.put(field, Cast.castValueToType(null, value.get(field), fieldSpec.getValue()));
        }
        return this.newRecord(record, null, updatedValue);
    }

    private R applyWithSchema(R record) {
        Schema valueSchema = this.operatingSchema(record);
        Schema updatedSchema = this.getOrBuildSchema(valueSchema);
        if (this.wholeValueCastType != null) {
            return this.newRecord(record, updatedSchema, Cast.castValueToType(valueSchema, this.operatingValue(record), this.wholeValueCastType));
        }
        Struct value = Requirements.requireStruct(this.operatingValue(record), PURPOSE);
        Struct updatedValue = new Struct(updatedSchema);
        for (Field field : value.schema().fields()) {
            Object origFieldValue = value.get(field);
            Schema.Type targetType = this.casts.get(field.name());
            Object newFieldValue = targetType != null ? Cast.castValueToType(field.schema(), origFieldValue, targetType) : origFieldValue;
            log.trace("Cast field '{}' from '{}' to '{}'", new Object[]{field.name(), origFieldValue, newFieldValue});
            updatedValue.put(updatedSchema.field(field.name()), newFieldValue);
        }
        return this.newRecord(record, updatedSchema, updatedValue);
    }

    private Schema getOrBuildSchema(Schema valueSchema) {
        SchemaBuilder builder;
        Schema updatedSchema = (Schema)this.schemaUpdateCache.get((Object)valueSchema);
        if (updatedSchema != null) {
            return updatedSchema;
        }
        if (this.wholeValueCastType != null) {
            builder = SchemaUtil.copySchemaBasics(valueSchema, this.convertFieldType(this.wholeValueCastType));
        } else {
            builder = SchemaUtil.copySchemaBasics(valueSchema, SchemaBuilder.struct());
            for (Field field : valueSchema.fields()) {
                if (this.casts.containsKey(field.name())) {
                    SchemaBuilder fieldBuilder = this.convertFieldType(this.casts.get(field.name()));
                    if (field.schema().isOptional()) {
                        fieldBuilder.optional();
                    }
                    if (field.schema().defaultValue() != null) {
                        Schema fieldSchema = field.schema();
                        fieldBuilder.defaultValue(Cast.castValueToType(fieldSchema, fieldSchema.defaultValue(), fieldBuilder.type()));
                    }
                    builder.field(field.name(), fieldBuilder.build());
                    continue;
                }
                builder.field(field.name(), field.schema());
            }
        }
        if (valueSchema.isOptional()) {
            builder.optional();
        }
        if (valueSchema.defaultValue() != null) {
            builder.defaultValue(Cast.castValueToType(valueSchema, valueSchema.defaultValue(), builder.type()));
        }
        updatedSchema = builder.build();
        this.schemaUpdateCache.put((Object)valueSchema, (Object)updatedSchema);
        return updatedSchema;
    }

    private SchemaBuilder convertFieldType(Schema.Type type) {
        switch (type) {
            case INT8: {
                return SchemaBuilder.int8();
            }
            case INT16: {
                return SchemaBuilder.int16();
            }
            case INT32: {
                return SchemaBuilder.int32();
            }
            case INT64: {
                return SchemaBuilder.int64();
            }
            case FLOAT32: {
                return SchemaBuilder.float32();
            }
            case FLOAT64: {
                return SchemaBuilder.float64();
            }
            case BOOLEAN: {
                return SchemaBuilder.bool();
            }
            case STRING: {
                return SchemaBuilder.string();
            }
        }
        throw new DataException("Unexpected type in Cast transformation: " + type);
    }

    private static Object encodeLogicalType(Schema schema, Object value) {
        switch (schema.name()) {
            case "org.apache.kafka.connect.data.Date": {
                return Date.fromLogical((Schema)schema, (java.util.Date)((java.util.Date)value));
            }
            case "org.apache.kafka.connect.data.Time": {
                return Time.fromLogical((Schema)schema, (java.util.Date)((java.util.Date)value));
            }
            case "org.apache.kafka.connect.data.Timestamp": {
                return Timestamp.fromLogical((Schema)schema, (java.util.Date)((java.util.Date)value));
            }
        }
        return value;
    }

    private static Object castValueToType(Schema schema, Object value, Schema.Type targetType) {
        try {
            Schema.Type inferredType;
            if (value == null) {
                return null;
            }
            Schema.Type type = inferredType = schema == null ? ConnectSchema.schemaType(value.getClass()) : schema.type();
            if (inferredType == null) {
                throw new DataException("Cast transformation was passed a value of type " + value.getClass() + " which is not supported by Connect's data API");
            }
            Cast.validCastType(inferredType, FieldType.INPUT);
            if (schema != null && schema.name() != null && targetType != Schema.Type.STRING) {
                value = Cast.encodeLogicalType(schema, value);
            }
            switch (targetType) {
                case INT8: {
                    return Cast.castToInt8(value);
                }
                case INT16: {
                    return Cast.castToInt16(value);
                }
                case INT32: {
                    return Cast.castToInt32(value);
                }
                case INT64: {
                    return Cast.castToInt64(value);
                }
                case FLOAT32: {
                    return Float.valueOf(Cast.castToFloat32(value));
                }
                case FLOAT64: {
                    return Cast.castToFloat64(value);
                }
                case BOOLEAN: {
                    return Cast.castToBoolean(value);
                }
                case STRING: {
                    return Cast.castToString(value);
                }
            }
            throw new DataException(targetType + " is not supported in the Cast transformation.");
        }
        catch (NumberFormatException e) {
            throw new DataException("Value (" + value.toString() + ") was out of range for requested data type", (Throwable)e);
        }
    }

    private static byte castToInt8(Object value) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? (byte)1 : 0;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        throw new DataException("Unexpected type in Cast transformation: " + value.getClass());
    }

    private static short castToInt16(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? (short)1 : 0;
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        throw new DataException("Unexpected type in Cast transformation: " + value.getClass());
    }

    private static int castToInt32(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new DataException("Unexpected type in Cast transformation: " + value.getClass());
    }

    private static long castToInt64(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new DataException("Unexpected type in Cast transformation: " + value.getClass());
    }

    private static float castToFloat32(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0f : 0.0f;
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new DataException("Unexpected type in Cast transformation: " + value.getClass());
    }

    private static double castToFloat64(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new DataException("Unexpected type in Cast transformation: " + value.getClass());
    }

    private static boolean castToBoolean(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new DataException("Unexpected type in Cast transformation: " + value.getClass());
    }

    private static String castToString(Object value) {
        if (value instanceof java.util.Date) {
            java.util.Date dateValue = (java.util.Date)value;
            return Values.dateFormatFor((java.util.Date)dateValue).format(dateValue);
        }
        if (value instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)value;
            return Base64.getEncoder().encodeToString(Utils.readBytes((ByteBuffer)byteBuffer));
        }
        if (value instanceof byte[]) {
            byte[] rawBytes = (byte[])value;
            return Base64.getEncoder().encodeToString(rawBytes);
        }
        return value.toString();
    }

    protected abstract Schema operatingSchema(R var1);

    protected abstract Object operatingValue(R var1);

    protected abstract R newRecord(R var1, Schema var2, Object var3);

    private static Map<String, Schema.Type> parseFieldTypes(List<String> mappings) {
        HashMap<String, Schema.Type> m = new HashMap<String, Schema.Type>();
        boolean isWholeValueCast = false;
        for (String mapping : mappings) {
            Schema.Type type;
            String[] parts = mapping.split(":");
            if (parts.length > 2) {
                throw new ConfigException("renames", mappings, "Invalid rename mapping: " + mapping);
            }
            if (parts.length == 1) {
                Schema.Type targetType = Schema.Type.valueOf((String)parts[0].trim().toUpperCase(Locale.ROOT));
                m.put(WHOLE_VALUE_CAST, Cast.validCastType(targetType, FieldType.OUTPUT));
                isWholeValueCast = true;
                continue;
            }
            try {
                type = Schema.Type.valueOf((String)parts[1].trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException("Invalid type found in casting spec: " + parts[1].trim(), (Object)e);
            }
            m.put(parts[0].trim(), Cast.validCastType(type, FieldType.OUTPUT));
        }
        if (isWholeValueCast && mappings.size() > 1) {
            throw new ConfigException("Cast transformations that specify a type to cast the entire value to may ony specify a single cast in their spec");
        }
        return m;
    }

    private static Schema.Type validCastType(Schema.Type type, FieldType fieldType) {
        switch (fieldType) {
            case INPUT: {
                if (SUPPORTED_CAST_INPUT_TYPES.contains(type)) break;
                throw new DataException("Cast transformation does not support casting from " + type + "; supported types are " + SUPPORTED_CAST_INPUT_TYPES);
            }
            case OUTPUT: {
                if (SUPPORTED_CAST_OUTPUT_TYPES.contains(type)) break;
                throw new ConfigException("Cast transformation does not support casting to " + type + "; supported types are " + SUPPORTED_CAST_OUTPUT_TYPES);
            }
        }
        return type;
    }

    public static final class Value<R extends ConnectRecord<R>>
    extends Cast<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.valueSchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return record.value();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), updatedSchema, updatedValue, record.timestamp());
        }
    }

    public static final class Key<R extends ConnectRecord<R>>
    extends Cast<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.keySchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return record.key();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), updatedSchema, updatedValue, record.valueSchema(), record.value(), record.timestamp());
        }
    }

    private static enum FieldType {
        INPUT,
        OUTPUT;

    }
}

