/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.internals.QuotaConfigs;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;

public class ClientQuotaControlManager {
    private final SnapshotRegistry snapshotRegistry;
    final TimelineHashMap<ClientQuotaEntity, TimelineHashMap<String, Double>> clientQuotaData;

    ClientQuotaControlManager(SnapshotRegistry snapshotRegistry) {
        this.snapshotRegistry = snapshotRegistry;
        this.clientQuotaData = new TimelineHashMap(snapshotRegistry, 0);
    }

    ControllerResult<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(Collection<ClientQuotaAlteration> quotaAlterations) {
        ArrayList<ApiMessageAndVersion> outputRecords = new ArrayList<ApiMessageAndVersion>();
        HashMap outputResults = new HashMap();
        quotaAlterations.forEach(quotaAlteration -> {
            HashMap<String, Double> alterations = new HashMap<String, Double>(quotaAlteration.ops().size());
            quotaAlteration.ops().forEach(op -> {
                if (alterations.containsKey(op.key())) {
                    outputResults.put(quotaAlteration.entity(), ApiError.fromThrowable((Throwable)new InvalidRequestException("Duplicate quota key " + op.key() + " not updating quota for this entity " + quotaAlteration.entity())));
                } else {
                    alterations.put(op.key(), op.value());
                }
            });
            if (outputResults.containsKey(quotaAlteration.entity())) {
                outputResults.put(quotaAlteration.entity(), ApiError.fromThrowable((Throwable)new InvalidRequestException("Ignoring duplicate entity " + quotaAlteration.entity())));
            } else {
                this.alterClientQuotaEntity(quotaAlteration.entity(), alterations, outputRecords, outputResults);
            }
        });
        return ControllerResult.atomicOf(outputRecords, outputResults);
    }

    public void replay(ClientQuotaRecord record) {
        HashMap entityMap = new HashMap(2);
        record.entity().forEach(entityData -> entityMap.put(entityData.entityType(), entityData.entityName()));
        ClientQuotaEntity entity = new ClientQuotaEntity(entityMap);
        TimelineHashMap<String, Double> quotas = this.clientQuotaData.get(entity);
        if (quotas == null) {
            quotas = new TimelineHashMap(this.snapshotRegistry, 0);
            this.clientQuotaData.put(entity, quotas);
        }
        if (record.remove()) {
            quotas.remove(record.key());
            if (quotas.size() == 0) {
                this.clientQuotaData.remove(entity);
            }
        } else {
            quotas.put(record.key(), record.value());
        }
    }

    private void alterClientQuotaEntity(ClientQuotaEntity entity, Map<String, Double> newQuotaConfigs, List<ApiMessageAndVersion> outputRecords, Map<ClientQuotaEntity, ApiError> outputResults) {
        HashMap<String, String> validatedEntityMap = new HashMap<String, String>(3);
        ApiError error = this.validateEntity(entity, validatedEntityMap);
        if (error.isFailure()) {
            outputResults.put(entity, error);
            return;
        }
        HashMap<String, ConfigDef.ConfigKey> configKeys = new HashMap<String, ConfigDef.ConfigKey>(4);
        error = this.configKeysForEntityType(validatedEntityMap, configKeys);
        if (error.isFailure()) {
            outputResults.put(entity, error);
            return;
        }
        Supplier<List> recordEntitySupplier = () -> validatedEntityMap.entrySet().stream().map(mapEntry -> new ClientQuotaRecord.EntityData().setEntityType((String)mapEntry.getKey()).setEntityName((String)mapEntry.getValue())).collect(Collectors.toList());
        ArrayList<ApiMessageAndVersion> newRecords = new ArrayList<ApiMessageAndVersion>(newQuotaConfigs.size());
        Map currentQuotas = this.clientQuotaData.containsKey(entity) ? (Map)this.clientQuotaData.get(entity) : Collections.emptyMap();
        for (Map.Entry<String, Double> entry : newQuotaConfigs.entrySet()) {
            String key = entry.getKey();
            Double newValue = entry.getValue();
            if (newValue == null) {
                if (!currentQuotas.containsKey(key)) continue;
                newRecords.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(recordEntitySupplier.get()).setKey(key).setRemove(true), MetadataRecordType.CLIENT_QUOTA_RECORD.highestSupportedVersion()));
                continue;
            }
            ApiError validationError = this.validateQuotaKeyValue(configKeys, key, newValue);
            if (validationError.isFailure()) {
                outputResults.put(entity, validationError);
                return;
            }
            Double currentValue = (Double)currentQuotas.get(key);
            if (Objects.equals(currentValue, newValue)) continue;
            newRecords.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(recordEntitySupplier.get()).setKey(key).setValue(newValue), MetadataRecordType.CLIENT_QUOTA_RECORD.highestSupportedVersion()));
        }
        outputRecords.addAll(newRecords);
        outputResults.put(entity, ApiError.NONE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ApiError configKeysForEntityType(Map<String, String> entity, Map<String, ConfigDef.ConfigKey> output) {
        Map configKeys;
        boolean hasUser = entity.containsKey("user");
        boolean hasClientId = entity.containsKey("client-id");
        boolean hasIp = entity.containsKey("ip");
        if (hasIp) {
            if (hasUser || hasClientId) {
                return new ApiError(Errors.INVALID_REQUEST, "Invalid quota entity combination, IP entity shouldnot be combined with User or ClientId");
            }
            if (!this.isValidIpEntity(entity.get("ip"))) return new ApiError(Errors.INVALID_REQUEST, entity.get("ip") + " is not a valid IP or resolvable host.");
            configKeys = QuotaConfigs.ipConfigs().configKeys();
        } else if (hasUser && hasClientId) {
            configKeys = QuotaConfigs.userConfigs().configKeys();
        } else if (hasUser) {
            configKeys = QuotaConfigs.userConfigs().configKeys();
        } else {
            if (!hasClientId) return new ApiError(Errors.INVALID_REQUEST, "Invalid empty client quota entity");
            configKeys = QuotaConfigs.clientConfigs().configKeys();
        }
        output.putAll(configKeys);
        return ApiError.NONE;
    }

    private ApiError validateQuotaKeyValue(Map<String, ConfigDef.ConfigKey> validKeys, String key, Double value) {
        ConfigDef.ConfigKey configKey = validKeys.get(key);
        if (configKey == null) {
            return new ApiError(Errors.INVALID_REQUEST, "Invalid configuration key " + key);
        }
        switch (configKey.type()) {
            case DOUBLE: {
                break;
            }
            case SHORT: 
            case INT: 
            case LONG: {
                Double epsilon = 1.0E-6;
                Long longValue = Double.valueOf(value + epsilon).longValue();
                if (!(Math.abs(longValue.doubleValue() - value) > epsilon)) break;
                return new ApiError(Errors.INVALID_REQUEST, "Configuration " + key + " must be a Long value");
            }
            default: {
                return new ApiError(Errors.UNKNOWN_SERVER_ERROR, "Unexpected config type " + configKey.type() + " should be Long or Double");
            }
        }
        return ApiError.NONE;
    }

    private boolean isValidIpEntity(String ip) {
        if (Objects.nonNull(ip)) {
            try {
                InetAddress.getByName(ip);
                return true;
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        return true;
    }

    private ApiError validateEntity(ClientQuotaEntity entity, Map<String, String> validatedEntityMap) {
        if (entity.entries().isEmpty()) {
            return new ApiError(Errors.INVALID_REQUEST, "Invalid empty client quota entity");
        }
        for (Map.Entry entityEntry : entity.entries().entrySet()) {
            String entityType = (String)entityEntry.getKey();
            String entityName = (String)entityEntry.getValue();
            if (validatedEntityMap.containsKey(entityType)) {
                return new ApiError(Errors.INVALID_REQUEST, "Invalid client quota entity, duplicate entity entry " + entityType);
            }
            if (Objects.equals(entityType, "user")) {
                validatedEntityMap.put("user", entityName);
            } else if (Objects.equals(entityType, "client-id")) {
                validatedEntityMap.put("client-id", entityName);
            } else if (Objects.equals(entityType, "ip")) {
                validatedEntityMap.put("ip", entityName);
            } else {
                return new ApiError(Errors.INVALID_REQUEST, "Unhandled client quota entity type: " + entityType);
            }
            if (entityName == null || !entityName.isEmpty()) continue;
            return new ApiError(Errors.INVALID_REQUEST, "Empty " + entityType + " not supported");
        }
        return ApiError.NONE;
    }

    ClientQuotaControlIterator iterator(long epoch) {
        return new ClientQuotaControlIterator(epoch);
    }

    class ClientQuotaControlIterator
    implements Iterator<List<ApiMessageAndVersion>> {
        private final long epoch;
        private final Iterator<Map.Entry<ClientQuotaEntity, TimelineHashMap<String, Double>>> iterator;

        ClientQuotaControlIterator(long epoch) {
            this.epoch = epoch;
            this.iterator = ClientQuotaControlManager.this.clientQuotaData.entrySet(epoch).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public List<ApiMessageAndVersion> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<ClientQuotaEntity, TimelineHashMap<String, Double>> entry = this.iterator.next();
            ClientQuotaEntity entity = entry.getKey();
            ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
            for (Map.Entry<String, Double> quotaEntry : entry.getValue().entrySet(this.epoch)) {
                ClientQuotaRecord record = new ClientQuotaRecord();
                for (Map.Entry entityEntry : entity.entries().entrySet()) {
                    record.entity().add(new ClientQuotaRecord.EntityData().setEntityType((String)entityEntry.getKey()).setEntityName((String)entityEntry.getValue()));
                }
                record.setKey(quotaEntry.getKey());
                record.setValue(quotaEntry.getValue());
                record.setRemove(false);
                records.add(new ApiMessageAndVersion((ApiMessage)record, MetadataRecordType.CLIENT_QUOTA_RECORD.highestSupportedVersion()));
            }
            return records;
        }
    }
}

