/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

class PartitionReassignmentReplicas {
    private final List<Integer> removing;
    private final List<Integer> adding;
    private final List<Integer> merged;

    private static Set<Integer> calculateDifference(List<Integer> a, List<Integer> b) {
        TreeSet<Integer> result = new TreeSet<Integer>(a);
        result.removeAll(b);
        return result;
    }

    PartitionReassignmentReplicas(List<Integer> currentReplicas, List<Integer> targetReplicas) {
        Set<Integer> removing = PartitionReassignmentReplicas.calculateDifference(currentReplicas, targetReplicas);
        this.removing = new ArrayList<Integer>(removing);
        Set<Integer> adding = PartitionReassignmentReplicas.calculateDifference(targetReplicas, currentReplicas);
        this.adding = new ArrayList<Integer>(adding);
        this.merged = new ArrayList<Integer>(targetReplicas);
        this.merged.addAll(removing);
    }

    List<Integer> removing() {
        return this.removing;
    }

    List<Integer> adding() {
        return this.adding;
    }

    List<Integer> merged() {
        return this.merged;
    }

    public int hashCode() {
        return Objects.hash(this.removing, this.adding, this.merged);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionReassignmentReplicas)) {
            return false;
        }
        PartitionReassignmentReplicas other = (PartitionReassignmentReplicas)o;
        return this.removing.equals(other.removing) && this.adding.equals(other.adding) && this.merged.equals(other.merged);
    }

    public String toString() {
        return "PartitionReassignmentReplicas(removing=" + this.removing + ", adding=" + this.adding + ", merged=" + this.merged + ")";
    }
}

