/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public final class ClusterImage {
    public static final ClusterImage EMPTY = new ClusterImage(Collections.emptyMap());
    private final Map<Integer, BrokerRegistration> brokers;

    public ClusterImage(Map<Integer, BrokerRegistration> brokers) {
        this.brokers = Collections.unmodifiableMap(brokers);
    }

    public boolean isEmpty() {
        return this.brokers.isEmpty();
    }

    public Map<Integer, BrokerRegistration> brokers() {
        return this.brokers;
    }

    public BrokerRegistration broker(int nodeId) {
        return this.brokers.get(nodeId);
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out, MetadataVersion metadataVersion) {
        ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
        for (BrokerRegistration broker : this.brokers.values()) {
            batch.add(broker.toRecord(metadataVersion));
        }
        out.accept(batch);
    }

    public int hashCode() {
        return this.brokers.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterImage)) {
            return false;
        }
        ClusterImage other = (ClusterImage)o;
        return this.brokers.equals(other.brokers);
    }

    public String toString() {
        return this.brokers.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", "));
    }
}

