/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public final class FeaturesImage {
    public static final FeaturesImage EMPTY = new FeaturesImage(Collections.emptyMap(), MetadataVersion.MINIMUM_KRAFT_VERSION);
    private final Map<String, Short> finalizedVersions;
    private final MetadataVersion metadataVersion;

    public FeaturesImage(Map<String, Short> finalizedVersions, MetadataVersion metadataVersion) {
        this.finalizedVersions = Collections.unmodifiableMap(finalizedVersions);
        this.metadataVersion = metadataVersion;
    }

    public boolean isEmpty() {
        return this.finalizedVersions.isEmpty();
    }

    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    public Map<String, Short> finalizedVersions() {
        return this.finalizedVersions;
    }

    private Optional<Short> finalizedVersion(String feature) {
        return Optional.ofNullable(this.finalizedVersions.get(feature));
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
        if (!this.metadataVersion.isLessThan(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION)) {
            batch.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(this.metadataVersion.featureLevel()), MetadataRecordType.FEATURE_LEVEL_RECORD.lowestSupportedVersion()));
        }
        for (Map.Entry<String, Short> entry : this.finalizedVersions.entrySet()) {
            if (entry.getKey().equals("metadata.version")) continue;
            batch.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(entry.getKey()).setFeatureLevel(entry.getValue()), MetadataRecordType.FEATURE_LEVEL_RECORD.highestSupportedVersion()));
        }
        out.accept(batch);
    }

    public int hashCode() {
        return this.finalizedVersions.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeaturesImage)) {
            return false;
        }
        FeaturesImage other = (FeaturesImage)o;
        return this.finalizedVersions.equals(other.finalizedVersions);
    }

    public String toString() {
        return "FeaturesImage{finalizedVersions=" + this.finalizedVersions + ", metadataVersion=" + this.metadataVersion + '}';
    }
}

