/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.internals.QuotaConfigs;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.mutable.BoundedList;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;

public class ClientQuotaControlManager {
    private final SnapshotRegistry snapshotRegistry;
    final TimelineHashMap<ClientQuotaEntity, TimelineHashMap<String, Double>> clientQuotaData;

    ClientQuotaControlManager(SnapshotRegistry snapshotRegistry) {
        this.snapshotRegistry = snapshotRegistry;
        this.clientQuotaData = new TimelineHashMap(snapshotRegistry, 0);
    }

    ControllerResult<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(Collection<ClientQuotaAlteration> quotaAlterations) {
        BoundedList outputRecords = BoundedList.newArrayBacked((int)10000);
        HashMap outputResults = new HashMap();
        quotaAlterations.forEach(arg_0 -> this.lambda$alterClientQuotas$1(outputResults, (List)outputRecords, arg_0));
        return ControllerResult.atomicOf((List<ApiMessageAndVersion>)outputRecords, outputResults);
    }

    public void replay(ClientQuotaRecord record) {
        HashMap entityMap = new HashMap(2);
        record.entity().forEach(entityData -> entityMap.put(entityData.entityType(), entityData.entityName()));
        ClientQuotaEntity entity = new ClientQuotaEntity(entityMap);
        TimelineHashMap quotas = (TimelineHashMap)this.clientQuotaData.get((Object)entity);
        if (quotas == null) {
            quotas = new TimelineHashMap(this.snapshotRegistry, 0);
            this.clientQuotaData.put((Object)entity, (Object)quotas);
        }
        if (record.remove()) {
            quotas.remove((Object)record.key());
            if (quotas.size() == 0) {
                this.clientQuotaData.remove((Object)entity);
            }
        } else {
            quotas.put((Object)record.key(), (Object)record.value());
        }
    }

    private void alterClientQuotaEntity(ClientQuotaEntity entity, Map<String, Double> newQuotaConfigs, List<ApiMessageAndVersion> outputRecords, Map<ClientQuotaEntity, ApiError> outputResults) {
        HashMap<String, String> validatedEntityMap = new HashMap<String, String>(3);
        ApiError error = this.validateEntity(entity, validatedEntityMap);
        if (error.isFailure()) {
            outputResults.put(entity, error);
            return;
        }
        HashMap<String, ConfigDef.ConfigKey> configKeys = new HashMap<String, ConfigDef.ConfigKey>(4);
        error = ClientQuotaControlManager.configKeysForEntityType(validatedEntityMap, configKeys);
        if (error.isFailure()) {
            outputResults.put(entity, error);
            return;
        }
        Supplier<List> recordEntitySupplier = () -> validatedEntityMap.entrySet().stream().map(mapEntry -> new ClientQuotaRecord.EntityData().setEntityType((String)mapEntry.getKey()).setEntityName((String)mapEntry.getValue())).collect(Collectors.toList());
        ArrayList<ApiMessageAndVersion> newRecords = new ArrayList<ApiMessageAndVersion>(newQuotaConfigs.size());
        Map currentQuotas = this.clientQuotaData.containsKey((Object)entity) ? (Map)this.clientQuotaData.get((Object)entity) : Collections.emptyMap();
        for (Map.Entry<String, Double> entry : newQuotaConfigs.entrySet()) {
            String key = entry.getKey();
            Double newValue = entry.getValue();
            if (newValue == null) {
                if (!currentQuotas.containsKey(key)) continue;
                newRecords.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(recordEntitySupplier.get()).setKey(key).setRemove(true), 0));
                continue;
            }
            ApiError validationError = ClientQuotaControlManager.validateQuotaKeyValue(configKeys, key, newValue);
            if (validationError.isFailure()) {
                outputResults.put(entity, validationError);
                return;
            }
            Double currentValue = (Double)currentQuotas.get(key);
            if (Objects.equals(currentValue, newValue)) continue;
            newRecords.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(recordEntitySupplier.get()).setKey(key).setValue(newValue), 0));
        }
        outputRecords.addAll(newRecords);
        outputResults.put(entity, ApiError.NONE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ApiError configKeysForEntityType(Map<String, String> entity, Map<String, ConfigDef.ConfigKey> output) {
        Map configKeys;
        boolean hasUser = entity.containsKey("user");
        boolean hasClientId = entity.containsKey("client-id");
        boolean hasIp = entity.containsKey("ip");
        if (hasIp) {
            if (hasUser || hasClientId) {
                return new ApiError(Errors.INVALID_REQUEST, "Invalid quota entity combination, IP entity shouldnot be combined with User or ClientId");
            }
            if (!ClientQuotaControlManager.isValidIpEntity(entity.get("ip"))) return new ApiError(Errors.INVALID_REQUEST, entity.get("ip") + " is not a valid IP or resolvable host.");
            configKeys = QuotaConfigs.ipConfigs().configKeys();
        } else {
            if (!hasUser && !hasClientId) return new ApiError(Errors.INVALID_REQUEST, "Invalid empty client quota entity");
            configKeys = QuotaConfigs.userAndClientQuotaConfigs().configKeys();
        }
        output.putAll(configKeys);
        return ApiError.NONE;
    }

    static ApiError validateQuotaKeyValue(Map<String, ConfigDef.ConfigKey> validKeys, String key, double value) {
        ConfigDef.ConfigKey configKey = validKeys.get(key);
        if (configKey == null) {
            return new ApiError(Errors.INVALID_REQUEST, "Invalid configuration key " + key);
        }
        if (value <= 0.0) {
            return new ApiError(Errors.INVALID_REQUEST, "Quota " + key + " must be greater than 0");
        }
        switch (configKey.type()) {
            case DOUBLE: {
                return ApiError.NONE;
            }
            case SHORT: {
                if (value > 32767.0) {
                    return new ApiError(Errors.INVALID_REQUEST, "Proposed value for " + key + " is too large for a SHORT.");
                }
                return ClientQuotaControlManager.getErrorForIntegralQuotaValue(value, key);
            }
            case INT: {
                if (value > 2.147483647E9) {
                    return new ApiError(Errors.INVALID_REQUEST, "Proposed value for " + key + " is too large for an INT.");
                }
                return ClientQuotaControlManager.getErrorForIntegralQuotaValue(value, key);
            }
            case LONG: {
                if (value > 9.223372036854776E18) {
                    return new ApiError(Errors.INVALID_REQUEST, "Proposed value for " + key + " is too large for a LONG.");
                }
                return ClientQuotaControlManager.getErrorForIntegralQuotaValue(value, key);
            }
        }
        return new ApiError(Errors.UNKNOWN_SERVER_ERROR, "Unexpected config type " + configKey.type() + " should be Long or Double");
    }

    static ApiError getErrorForIntegralQuotaValue(double value, String key) {
        double remainder = Math.abs(value % 1.0);
        if (remainder > 1.0E-6) {
            return new ApiError(Errors.INVALID_REQUEST, key + " cannot be a fractional value.");
        }
        return ApiError.NONE;
    }

    static boolean isValidIpEntity(String ip) {
        if (ip == null) {
            return true;
        }
        try {
            InetAddress.getByName(ip);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private ApiError validateEntity(ClientQuotaEntity entity, Map<String, String> validatedEntityMap) {
        if (entity.entries().isEmpty()) {
            return new ApiError(Errors.INVALID_REQUEST, "Invalid empty client quota entity");
        }
        for (Map.Entry entityEntry : entity.entries().entrySet()) {
            String entityType = (String)entityEntry.getKey();
            String entityName = (String)entityEntry.getValue();
            if (validatedEntityMap.containsKey(entityType)) {
                return new ApiError(Errors.INVALID_REQUEST, "Invalid client quota entity, duplicate entity entry " + entityType);
            }
            if (Objects.equals(entityType, "user")) {
                validatedEntityMap.put("user", entityName);
            } else if (Objects.equals(entityType, "client-id")) {
                validatedEntityMap.put("client-id", entityName);
            } else if (Objects.equals(entityType, "ip")) {
                validatedEntityMap.put("ip", entityName);
            } else {
                return new ApiError(Errors.INVALID_REQUEST, "Unhandled client quota entity type: " + entityType);
            }
            if (entityName == null || !entityName.isEmpty()) continue;
            return new ApiError(Errors.INVALID_REQUEST, "Empty " + entityType + " not supported");
        }
        return ApiError.NONE;
    }

    private /* synthetic */ void lambda$alterClientQuotas$1(Map outputResults, List outputRecords, ClientQuotaAlteration quotaAlteration) {
        HashMap<String, Double> alterations = new HashMap<String, Double>(quotaAlteration.ops().size());
        quotaAlteration.ops().forEach(op -> {
            if (alterations.containsKey(op.key())) {
                outputResults.put(quotaAlteration.entity(), ApiError.fromThrowable((Throwable)new InvalidRequestException("Duplicate quota key " + op.key() + " not updating quota for this entity " + quotaAlteration.entity())));
            } else {
                alterations.put(op.key(), op.value());
            }
        });
        if (outputResults.containsKey(quotaAlteration.entity())) {
            outputResults.put(quotaAlteration.entity(), ApiError.fromThrowable((Throwable)new InvalidRequestException("Ignoring duplicate entity " + quotaAlteration.entity())));
        } else {
            this.alterClientQuotaEntity(quotaAlteration.entity(), alterations, outputRecords, outputResults);
        }
    }
}

