/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.http.websocketx;

import java.net.URI;
import java.util.Map;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker00;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker07;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker08;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketClientHandshakerFactory {
    public WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, Map<String, String> customHeaders) {
        return this.newHandshaker(webSocketURL, version, subprotocol, allowExtensions, customHeaders, Long.MAX_VALUE);
    }

    public WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, Map<String, String> customHeaders, long maxFramePayloadLength) {
        if (version == WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(webSocketURL, WebSocketVersion.V13, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength);
        }
        if (version == WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(webSocketURL, WebSocketVersion.V08, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength);
        }
        if (version == WebSocketVersion.V07) {
            return new WebSocketClientHandshaker07(webSocketURL, WebSocketVersion.V07, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength);
        }
        if (version == WebSocketVersion.V00) {
            return new WebSocketClientHandshaker00(webSocketURL, WebSocketVersion.V00, subprotocol, customHeaders, maxFramePayloadLength);
        }
        throw new WebSocketHandshakeException("Protocol version " + version.toString() + " not supported.");
    }
}

