/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import org.apache.kudu.annotations.InterfaceAudience;

@InterfaceAudience.Private
public class StringUtil {
    public static void appendEscapedSQLString(String s, StringBuilder sb) {
        block11: for (int i = 0; i < s.length(); ++i) {
            char currentChar = s.charAt(i);
            switch (currentChar) {
                case '\u0000': {
                    sb.append("\\0");
                    continue block11;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block11;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                case '\u001a': {
                    sb.append("\\Z");
                    continue block11;
                }
                default: {
                    if (currentChar < ' ') {
                        sb.append("\\u");
                        String hex = Integer.toHexString(currentChar);
                        for (int j = 4; j > hex.length(); --j) {
                            sb.append('0');
                        }
                        sb.append(hex);
                        continue block11;
                    }
                    sb.append(currentChar);
                }
            }
        }
    }

    private StringUtil() {
    }
}

