/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Callback;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.RecoverableException;
import org.apache.kudu.client.RpcTraceFrame;
import org.apache.kudu.client.Status;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class AuthnTokenReacquirer {
    private final AsyncKuduClient client;
    private final Object queuedRpcsLock = new Object();
    @GuardedBy(value="queuedRpcsLock")
    private ArrayList<KuduRpc<?>> queuedRpcs = Lists.newArrayList();

    AuthnTokenReacquirer(AsyncKuduClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> void handleAuthnTokenExpiration(KuduRpc<R> rpc) {
        boolean doReacquire = false;
        Object object = this.queuedRpcsLock;
        synchronized (object) {
            if (this.queuedRpcs.isEmpty()) {
                doReacquire = true;
            }
            this.queuedRpcs.add(rpc);
        }
        rpc.addTrace(new RpcTraceFrame.RpcTraceFrameBuilder(rpc.method(), RpcTraceFrame.Action.GET_NEW_AUTHENTICATION_TOKEN_THEN_RETRY).build());
        if (doReacquire) {
            this.reacquireAuthnToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KuduRpc<?>> swapQueuedRpcs() {
        ArrayList<KuduRpc<?>> rpcList;
        Object object = this.queuedRpcsLock;
        synchronized (object) {
            rpcList = this.queuedRpcs;
            this.queuedRpcs = Lists.newArrayList();
        }
        assert (!rpcList.isEmpty());
        return rpcList;
    }

    private void reacquireAuthnToken() {
        final class NewAuthnTokenCB
        implements Callback<Void, Boolean> {
            NewAuthnTokenCB() {
            }

            public Void call(Boolean tokenAcquired) throws Exception {
                this.retryQueuedRpcs();
                return null;
            }

            void retryQueuedRpcs() {
                List list = AuthnTokenReacquirer.this.swapQueuedRpcs();
                for (KuduRpc rpc : list) {
                    AuthnTokenReacquirer.this.client.handleRetryableErrorNoDelay(rpc, null);
                }
            }
        }
        NewAuthnTokenCB newTokenCb = new NewAuthnTokenCB();
        final class NewAuthnTokenErrB
        implements Callback<Void, Exception> {
            private static final int MAX_ATTEMPTS = 5;
            private final NewAuthnTokenCB cb;
            private int attempts = 0;

            NewAuthnTokenErrB(NewAuthnTokenCB cb) {
                this.cb = cb;
            }

            public Void call(Exception e) {
                if (e instanceof RecoverableException && this.attempts < 5) {
                    AuthnTokenReacquirer.this.client.reconnectToCluster(this.cb, this);
                    ++this.attempts;
                    return null;
                }
                this.failQueuedRpcs();
                return null;
            }

            void failQueuedRpcs() {
                List rpcList = AuthnTokenReacquirer.this.swapQueuedRpcs();
                for (KuduRpc rpc : rpcList) {
                    NonRecoverableException reason = new NonRecoverableException(Status.NotAuthorized(String.format("cannot re-acquire authentication token after %d attempts", 5)));
                    rpc.errback(reason);
                }
            }
        }
        NewAuthnTokenErrB newTokenErrb = new NewAuthnTokenErrB(newTokenCb);
        this.client.reconnectToCluster(newTokenCb, newTokenErrb);
    }
}

