/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.streaming.StreamingConfig;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="streamingMgmtService")
public class StreamingService
extends BasicService {
    @Autowired
    private AclEvaluate aclEvaluate;

    public List<StreamingConfig> listAllStreamingConfigs(String table) throws IOException {
        ArrayList<StreamingConfig> streamingConfigs = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)table)) {
            streamingConfigs = this.getStreamingManager().listAllStreaming();
        } else {
            StreamingConfig config = this.getStreamingManager().getStreamingConfig(table);
            if (config != null) {
                streamingConfigs.add(config);
            }
        }
        return streamingConfigs;
    }

    public List<StreamingConfig> getStreamingConfigs(String table, String project, Integer limit, Integer offset) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        List<StreamingConfig> streamingConfigs = this.listAllStreamingConfigs(table);
        if (limit == null || offset == null) {
            return streamingConfigs;
        }
        if (streamingConfigs.size() - offset < limit) {
            return streamingConfigs.subList(offset, streamingConfigs.size());
        }
        return streamingConfigs.subList(offset, offset + limit);
    }

    public StreamingConfig createStreamingConfig(StreamingConfig config, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        Message msg = MsgPicker.getMsg();
        if (this.getStreamingManager().getStreamingConfig(config.getName()) != null) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getSTREAMING_CONFIG_ALREADY_EXIST(), config.getName()));
        }
        StreamingConfig streamingConfig = this.getStreamingManager().createStreamingConfig(config);
        return streamingConfig;
    }

    public StreamingConfig updateStreamingConfig(StreamingConfig config, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        return this.getStreamingManager().updateStreamingConfig(config);
    }

    public void dropStreamingConfig(StreamingConfig config, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getStreamingManager().removeStreamingConfig(config);
    }
}

