/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.BufferedLogger;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.MailService;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.execution.CheckpointExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinHealthCheckJob
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(KylinHealthCheckJob.class);
    private static final Option OPTION_FIX;
    final KylinConfig config;
    final BufferedLogger reporter = new BufferedLogger(logger);
    final CubeManager cubeManager;

    public static void main(String[] args) throws Exception {
        new KylinHealthCheckJob().execute(args);
    }

    public KylinHealthCheckJob() {
        this(KylinConfig.getInstanceFromEnv());
    }

    public KylinHealthCheckJob(KylinConfig config) {
        this.config = config;
        this.cubeManager = CubeManager.getInstance((KylinConfig)config);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_FIX);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        logger.info("options: '" + optionsHelper.getOptionsAsString() + "'");
        this.checkCubeHealth();
    }

    private void checkCubeHealth() throws Exception {
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.config);
        List cubes = cubeManager.listAllCubes();
        this.checkErrorMeta();
        this.checkSegmentHDFSPath(cubes);
        this.checkHBaseTables(cubes);
        this.checkCubeHoles(cubes);
        this.checkTooManySegments(cubes);
        this.checkStaleSegments(cubes);
        this.checkOutOfDateCube(cubes);
        this.checkDataExpansionRate(cubes);
        this.checkCubeDescParams(cubes);
        this.checkStoppedJob();
        this.sendMail(this.reporter.getBufferedLog());
    }

    private void sendMail(String content) {
        logger.info("Send Kylin cluster report");
        String subject = "Kylin Cluster Health Report of " + this.config.getClusterName() + " on " + new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT).format(new Date());
        ArrayList users = Lists.newArrayList((Object[])this.config.getAdminDls());
        new MailService(this.config).sendMail((List)users, subject, content, false);
    }

    private void checkErrorMeta() {
        this.reporter.log("## Checking metadata");
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.config);
        for (String cube : cubeManager.getErrorCubes()) {
            this.reporter.log("Error loading CubeDesc at " + cube);
        }
        DataModelManager modelManager = DataModelManager.getInstance((KylinConfig)this.config);
        for (String model : modelManager.getErrorModels()) {
            this.reporter.log("Error loading DataModelDesc at " + model);
        }
    }

    private void checkStoppedJob() throws Exception {
        this.reporter.log("## Cleanup stopped job");
        int staleJobThresholdInDays = this.config.getStaleJobThresholdInDays();
        long outdatedJobTimeCut = System.currentTimeMillis() - 1L * (long)staleJobThresholdInDays * 24L * 60L * 60L * 1000L;
        ExecutableDao executableDao = ExecutableDao.getInstance((KylinConfig)this.config);
        List allExecutable = executableDao.getJobs();
        for (ExecutablePO executable : allExecutable) {
            long lastModified = executable.getLastModified();
            String jobStatus = executableDao.getJobOutput(executable.getUuid()).getStatus();
            if (lastModified >= outdatedJobTimeCut || !ExecutableState.ERROR.toString().equals(jobStatus) && !ExecutableState.STOPPED.toString().equals(jobStatus)) continue;
            if (executable.getType().equals(CubingJob.class.getName()) || executable.getType().equals(CheckpointExecutable.class.getName())) {
                this.reporter.log("Should discard job: {}, which in ERROR/STOPPED state for {} days", new Object[]{executable.getId(), staleJobThresholdInDays});
                continue;
            }
            logger.warn("Unknown out of date job: {} with type: {}, which in ERROR/STOPPED state for {} days", new Object[]{executable.getId(), executable.getType(), staleJobThresholdInDays});
        }
    }

    private void checkSegmentHDFSPath(List<CubeInstance> cubes) throws IOException {
        this.reporter.log("## Fix missing HDFS path of segments");
        FileSystem defaultFs = HadoopUtil.getWorkingFileSystem();
        for (CubeInstance cube : cubes) {
            for (CubeSegment segment : cube.getSegments()) {
                String path;
                String jobUuid = segment.getLastBuildJobID();
                if (jobUuid == null || jobUuid.equals("") || defaultFs.exists(new Path(path = JobBuilderSupport.getJobWorkingDir((String)this.config.getHdfsWorkingDirectory(), (String)jobUuid)))) continue;
                this.reporter.log("Project: {} cube: {} segment: {} cube id data: {} don't exist and need to rebuild it", new Object[]{cube.getProject(), cube.getName(), segment, path});
                this.reporter.log("The rebuild url: -d '{\"startTime\":{}, \"endTime\":{}, \"buildType\":\"REFRESH\"}' /kylin/api/cubes/{}/build", new Object[]{segment.getTSRange().start, segment.getTSRange().end, cube.getName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHBaseTables(List<CubeInstance> cubes) throws IOException {
        this.reporter.log("## Checking HBase Table of segments");
        HBaseAdmin hbaseAdmin = new HBaseAdmin(HBaseConfiguration.create());
        try {
            for (CubeInstance cube : cubes) {
                for (CubeSegment segment : cube.getSegments()) {
                    String tableName;
                    if (segment.getStatus() == SegmentStatusEnum.NEW || hbaseAdmin.tableExists(tableName = segment.getStorageLocationIdentifier()) && hbaseAdmin.isTableEnabled(tableName)) continue;
                    this.reporter.log("HBase table: {} not exist for segment: {}, project: {}", new Object[]{tableName, segment, cube.getProject()});
                    this.reporter.log("The rebuild url: -d '{\"startTime\":{}, \"endTime\":{}, \"buildType\":\"REFRESH\"}' /kylin/api/cubes/{}/build", new Object[]{segment.getTSRange().start, segment.getTSRange().end, cube.getName()});
                }
            }
        }
        finally {
            if (null != hbaseAdmin) {
                hbaseAdmin.close();
            }
        }
    }

    private void checkCubeHoles(List<CubeInstance> cubes) {
        this.reporter.log("## Checking holes of Cubes");
        for (CubeInstance cube : cubes) {
            List holes;
            if (!cube.isReady() || (holes = this.cubeManager.calculateHoles(cube.getName())).size() <= 0) continue;
            this.reporter.log("{} holes in cube: {}, project: {}", new Object[]{holes.size(), cube.getName(), cube.getProject()});
        }
    }

    private void checkTooManySegments(List<CubeInstance> cubes) {
        this.reporter.log("## Checking too many segments of Cubes");
        int warningSegmentNum = this.config.getWarningSegmentNum();
        if (warningSegmentNum < 0) {
            return;
        }
        for (CubeInstance cube : cubes) {
            if (cube.getSegments().size() < warningSegmentNum) continue;
            this.reporter.log("Too many segments: {} for cube: {}, project: {}, please merge the segments", new Object[]{cube.getSegments().size(), cube.getName(), cube.getProject()});
        }
    }

    private void checkStaleSegments(List<CubeInstance> cubes) {
        for (CubeInstance cube : cubes) {
            for (CubeSegment segment : cube.getSegments()) {
                if (segment.getInputRecordsSize() != 0L) continue;
                logger.info("Segment: {} in project: {} may be stale", (Object)segment, (Object)cube.getProject());
            }
        }
    }

    private void checkOutOfDateCube(List<CubeInstance> cubes) {
        this.reporter.log("## Checking out-of-date Cubes");
        int staleCubeThresholdInDays = this.config.getStaleCubeThresholdInDays();
        long outdatedCubeTimeCut = System.currentTimeMillis() - 1L * (long)staleCubeThresholdInDays * 24L * 60L * 60L * 1000L;
        for (CubeInstance cube : cubes) {
            long lastTime = cube.getLastModified();
            logger.info("Cube {} last modified time: {}, {}", new Object[]{cube.getName(), new Date(lastTime), cube.getDescriptor().getNotifyList()});
            if (lastTime >= outdatedCubeTimeCut) continue;
            if (cube.isReady()) {
                this.reporter.log("Ready Cube: {} in project: {} is not built more then {} days, maybe it can be disabled", new Object[]{cube.getName(), cube.getProject(), staleCubeThresholdInDays});
                continue;
            }
            this.reporter.log("Disabled Cube: {} in project: {} is not built more then {} days, maybe it can be deleted", new Object[]{cube.getName(), cube.getProject(), staleCubeThresholdInDays});
        }
    }

    private void checkDataExpansionRate(List<CubeInstance> cubes) {
        int warningExpansionRate = this.config.getWarningCubeExpansionRate();
        int expansionCheckMinCubeSizeInGb = this.config.getExpansionCheckMinCubeSizeInGb();
        for (CubeInstance cube : cubes) {
            long sizeRecordSize = cube.getInputRecordSizeBytes();
            if (sizeRecordSize <= 0L) continue;
            long cubeDataSize = cube.getSizeKB() * 1024L;
            double expansionRate = (double)cubeDataSize / (double)sizeRecordSize;
            if (sizeRecordSize <= 1L * (long)expansionCheckMinCubeSizeInGb * 1024L * 1024L * 1024L || !(expansionRate > (double)warningExpansionRate)) continue;
            logger.info("Cube: {} in project: {} with too large expansion rate: {}, cube data size: {}G", new Object[]{cube.getName(), cube.getProject(), expansionRate, cubeDataSize / 1024L / 1024L / 1024L});
        }
    }

    private void checkCubeDescParams(List<CubeInstance> cubes) {
        for (CubeInstance cube : cubes) {
            long retentionRange;
            CubeDesc desc = cube.getDescriptor();
            long[] autoMergeTS = desc.getAutoMergeTimeRanges();
            if (autoMergeTS == null || autoMergeTS.length == 0) {
                logger.info("Cube: {} in project: {} with no auto merge params", (Object)cube.getName(), (Object)cube.getProject());
            }
            if ((retentionRange = desc.getRetentionRange()) != 0L) continue;
            logger.info("Cube: {} in project: {} with no retention params", (Object)cube.getName(), (Object)cube.getProject());
        }
    }

    static {
        OptionBuilder.withArgName((String)"fix");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Fix the unhealthy cube");
        OPTION_FIX = OptionBuilder.create((String)"fix");
    }
}

