/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCleanupJob
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(StorageCleanupJob.class);
    protected static final Option OPTION_DELETE;
    protected final KylinConfig config;
    protected final FileSystem fs;
    protected final ExecutableManager executableManager;
    protected boolean delete = false;

    public StorageCleanupJob() throws IOException {
        this(KylinConfig.getInstanceFromEnv(), HadoopUtil.getWorkingFileSystem((Configuration)HadoopUtil.getCurrentConfiguration()));
    }

    public StorageCleanupJob(KylinConfig config, FileSystem fs) {
        this.config = config;
        this.fs = fs;
        this.executableManager = ExecutableManager.getInstance((KylinConfig)config);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DELETE);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        logger.info("options: '" + optionsHelper.getOptionsAsString() + "'");
        logger.info("delete option value: '" + optionsHelper.getOptionValue(OPTION_DELETE) + "'");
        this.delete = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_DELETE));
        this.cleanup();
    }

    public void cleanup() throws Exception {
        ProjectManager projectManager = ProjectManager.getInstance((KylinConfig)this.config);
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.config);
        List projects = projectManager.listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        for (String project : projects) {
            String tmpPath = this.config.getJobTmpDir(project);
            if (this.delete) {
                logger.info("Deleting HDFS path " + tmpPath);
                if (!this.fs.exists(new Path(tmpPath))) continue;
                this.fs.delete(new Path(tmpPath), true);
                continue;
            }
            logger.info("Dry run, pending delete HDFS path " + tmpPath);
        }
        List cubes = cubeManager.listAllCubes();
        for (CubeInstance cube : cubes) {
            List segments = cube.getSegments().stream().map(segment -> segment.getName() + "_" + segment.getStorageLocationIdentifier()).collect(Collectors.toList());
            String project = cube.getProject();
            Path cubePath = new Path(this.config.getHdfsWorkingDirectory(project) + "/parquet/" + cube.getName());
            if (this.fs.exists(cubePath)) {
                FileStatus[] fStatus = this.fs.listStatus(cubePath);
                if (fStatus == null) continue;
                for (FileStatus status : fStatus) {
                    String segment2 = status.getPath().getName();
                    if (segments.contains(segment2)) continue;
                    if (this.delete) {
                        logger.info("Deleting HDFS path " + status.getPath());
                        this.fs.delete(status.getPath(), true);
                        continue;
                    }
                    logger.info("Dry run, pending delete HDFS path " + status.getPath());
                }
                continue;
            }
            logger.warn("Cube path doesn't exist! The path is " + cubePath);
        }
    }

    static {
        OptionBuilder.withArgName((String)"delete");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Delete the unused storage");
        OPTION_DELETE = OptionBuilder.create((String)"delete");
    }
}

