/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security.saml;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.security.KylinUserManager;
import org.apache.kylin.rest.security.ManagedUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;

public class SAMLSimpleUserDetailsService
implements SAMLUserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(SAMLSimpleUserDetailsService.class);
    private static final String NO_EXISTENCE_PASSWORD = "NO_PASSWORD";
    private String[] defaultAuthorities = new String[]{"ALL_USERS"};

    public void setDefaultAuthorities(String[] defaultAuthorities) {
        this.defaultAuthorities = defaultAuthorities;
    }

    public Object loadUserBySAML(SAMLCredential samlCredential) throws UsernameNotFoundException {
        String userEmail = samlCredential.getAttributeAsString("email");
        logger.debug("samlCredential.email:" + userEmail);
        String userName = userEmail.substring(0, userEmail.indexOf("@"));
        KylinUserManager userManager = KylinUserManager.getInstance(KylinConfig.getInstanceFromEnv());
        ManagedUser existUser = userManager.get(userName);
        if (existUser == null) {
            ManagedUser user = new ManagedUser(userName, NO_EXISTENCE_PASSWORD, (Boolean)true, this.defaultAuthorities);
            userManager.update(user);
        }
        return userManager.get(userName);
    }
}

