/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.metrics.common.Metrics;
import org.apache.kylin.common.metrics.common.MetricsFactory;
import org.apache.kylin.common.metrics.metrics2.CodahaleMetrics;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.rest.service.BasicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="metricsService")
public class MetricsService
extends BasicService {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsService.class);

    public String getMetrics(String type) throws Exception {
        if (!this.getConfig().getQueryMetrics2Enabled()) {
            throw new IllegalStateException("Please enable query metrics2");
        }
        Metrics instance = MetricsFactory.getInstance();
        String metric = null;
        if (!(instance instanceof CodahaleMetrics)) {
            throw new IllegalStateException("Please use CodahaleMetrics to collect your metrics");
        }
        try {
            metric = ((CodahaleMetrics)instance).dumpJson();
            if (StringUtils.isNotBlank((String)type)) {
                Map map = (Map)JsonUtil.readValue((String)metric, (TypeReference)new TypeReference<Map<String, Object>>(){});
                metric = String.valueOf(map.get(type));
            }
        }
        catch (Exception e) {
            LOG.error("Dump metric json error, ", (Throwable)e);
        }
        return metric;
    }
}

