/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class GermanAnalyzer
extends Analyzer {
    public static final String[] GERMAN_STOP_WORDS = new String[]{"einer", "eine", "eines", "einem", "einen", "der", "die", "das", "dass", "da\u00df", "du", "er", "sie", "es", "was", "wer", "wie", "wir", "und", "oder", "ohne", "mit", "am", "im", "in", "aus", "auf", "ist", "sein", "war", "wird", "ihr", "ihre", "ihres", "als", "f\u00fcr", "von", "mit", "dich", "dir", "mich", "mir", "mein", "sein", "kein", "durch", "wegen", "wird"};
    private Set stopSet = new HashSet();
    private Set exclusionSet = new HashSet();

    public GermanAnalyzer() {
        this.stopSet = StopFilter.makeStopSet((String[])GERMAN_STOP_WORDS);
        this.setOverridesTokenStreamMethod(GermanAnalyzer.class);
    }

    public GermanAnalyzer(String[] stopwords) {
        this.stopSet = StopFilter.makeStopSet((String[])stopwords);
        this.setOverridesTokenStreamMethod(GermanAnalyzer.class);
    }

    public GermanAnalyzer(Map stopwords) {
        this.stopSet = new HashSet(stopwords.keySet());
        this.setOverridesTokenStreamMethod(GermanAnalyzer.class);
    }

    public GermanAnalyzer(File stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet((File)stopwords);
        this.setOverridesTokenStreamMethod(GermanAnalyzer.class);
    }

    public void setStemExclusionTable(String[] exclusionlist) {
        this.exclusionSet = StopFilter.makeStopSet((String[])exclusionlist);
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(Map exclusionlist) {
        this.exclusionSet = new HashSet(exclusionlist.keySet());
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(File exclusionlist) throws IOException {
        this.exclusionSet = WordlistLoader.getWordSet((File)exclusionlist);
        this.setPreviousTokenStream(null);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(reader);
        result = new StandardFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopSet);
        result = new GermanStemFilter((TokenStream)result, this.exclusionSet);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(reader);
            streams.result = new StandardFilter((TokenStream)streams.source);
            streams.result = new LowerCaseFilter(streams.result);
            streams.result = new StopFilter(streams.result, this.stopSet);
            streams.result = new GermanStemFilter(streams.result, this.exclusionSet);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

