/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fa;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.ar.ArabicLetterTokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;

public final class PersianAnalyzer
extends Analyzer {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private Set stoptable = new HashSet();
    public static final String STOPWORDS_COMMENT = "#";

    public PersianAnalyzer() {
        try {
            InputStream stream = PersianAnalyzer.class.getResourceAsStream(DEFAULT_STOPWORD_FILE);
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            this.stoptable = WordlistLoader.getWordSet((Reader)reader, (String)STOPWORDS_COMMENT);
            reader.close();
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PersianAnalyzer(String[] stopwords) {
        this.stoptable = StopFilter.makeStopSet((String[])stopwords);
    }

    public PersianAnalyzer(Hashtable stopwords) {
        this.stoptable = new HashSet(stopwords.keySet());
    }

    public PersianAnalyzer(File stopwords) throws IOException {
        this.stoptable = WordlistLoader.getWordSet((File)stopwords, (String)STOPWORDS_COMMENT);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new ArabicLetterTokenizer(reader);
        result = new LowerCaseFilter((TokenStream)result);
        result = new ArabicNormalizationFilter((TokenStream)result);
        result = new PersianNormalizationFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stoptable);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new ArabicLetterTokenizer(reader);
            streams.result = new LowerCaseFilter((TokenStream)streams.source);
            streams.result = new ArabicNormalizationFilter(streams.result);
            streams.result = new PersianNormalizationFilter(streams.result);
            streams.result = new StopFilter(streams.result, this.stoptable);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

