/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.encoding;

import org.apache.lucene.facet.encoding.IntEncoder;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public abstract class ChunksIntEncoder
extends IntEncoder {
    protected final IntsRef encodeQueue;
    protected int indicator = 0;
    protected byte ordinal = 0;

    protected ChunksIntEncoder(int chunkSize) {
        this.encodeQueue = new IntsRef(chunkSize);
    }

    protected void encodeChunk(BytesRef buf) {
        int maxBytesRequired = buf.length + 1 + this.encodeQueue.length * 4;
        if (buf.bytes.length < maxBytesRequired) {
            buf.grow(maxBytesRequired);
        }
        buf.bytes[buf.length++] = (byte)this.indicator;
        for (int i = 0; i < this.encodeQueue.length; ++i) {
            int value = this.encodeQueue.ints[i];
            if ((value & 0xFFFFFF80) == 0) {
                buf.bytes[buf.length] = (byte)value;
                ++buf.length;
                continue;
            }
            if ((value & 0xFFFFC000) == 0) {
                buf.bytes[buf.length] = (byte)(0x80 | (value & 0x3F80) >> 7);
                buf.bytes[buf.length + 1] = (byte)(value & 0x7F);
                buf.length += 2;
                continue;
            }
            if ((value & 0xFFE00000) == 0) {
                buf.bytes[buf.length] = (byte)(0x80 | (value & 0x1FC000) >> 14);
                buf.bytes[buf.length + 1] = (byte)(0x80 | (value & 0x3F80) >> 7);
                buf.bytes[buf.length + 2] = (byte)(value & 0x7F);
                buf.length += 3;
                continue;
            }
            if ((value & 0xF0000000) == 0) {
                buf.bytes[buf.length] = (byte)(0x80 | (value & 0xFE00000) >> 21);
                buf.bytes[buf.length + 1] = (byte)(0x80 | (value & 0x1FC000) >> 14);
                buf.bytes[buf.length + 2] = (byte)(0x80 | (value & 0x3F80) >> 7);
                buf.bytes[buf.length + 3] = (byte)(value & 0x7F);
                buf.length += 4;
                continue;
            }
            buf.bytes[buf.length] = (byte)(0x80 | (value & 0xF0000000) >> 28);
            buf.bytes[buf.length + 1] = (byte)(0x80 | (value & 0xFE00000) >> 21);
            buf.bytes[buf.length + 2] = (byte)(0x80 | (value & 0x1FC000) >> 14);
            buf.bytes[buf.length + 3] = (byte)(0x80 | (value & 0x3F80) >> 7);
            buf.bytes[buf.length + 4] = (byte)(value & 0x7F);
            buf.length += 5;
        }
        this.ordinal = 0;
        this.indicator = 0;
        this.encodeQueue.length = 0;
    }
}

