/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import org.apache.lucene.facet.complements.ComplementCountingAggregator;
import org.apache.lucene.facet.search.Aggregator;
import org.apache.lucene.facet.search.CountingAggregator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public class CountFacetRequest
extends FacetRequest {
    public CountFacetRequest(CategoryPath path, int num) {
        super(path, num);
    }

    @Override
    public Aggregator createAggregator(boolean useComplements, FacetArrays arrays, TaxonomyReader taxonomy) {
        int[] a = arrays.getIntArray();
        if (useComplements) {
            return new ComplementCountingAggregator(a);
        }
        return new CountingAggregator(a);
    }

    @Override
    public double getValueOf(FacetArrays arrays, int ordinal) {
        return arrays.getIntArray()[ordinal];
    }

    @Override
    public FacetRequest.FacetArraysSource getFacetArraysSource() {
        return FacetRequest.FacetArraysSource.INT;
    }
}

