/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.util.PriorityQueue;

public abstract class DepthOneFacetResultsHandler
extends FacetResultsHandler {
    public DepthOneFacetResultsHandler(TaxonomyReader taxonomyReader, FacetRequest facetRequest, FacetArrays facetArrays) {
        super(taxonomyReader, facetRequest, facetArrays);
        assert (facetRequest.getDepth() == 1) : "this handler only computes the top-K facets at depth 1";
        assert (facetRequest.numResults == facetRequest.getNumLabel()) : "this handler always labels all top-K results";
        assert (facetRequest.getSortOrder() == FacetRequest.SortOrder.DESCENDING) : "this handler always sorts results in descending order";
    }

    protected abstract double valueOf(int var1);

    protected abstract void addSiblings(int var1, int[] var2, ArrayList<FacetResultNode> var3) throws IOException;

    protected abstract int addSiblings(int var1, int[] var2, PriorityQueue<FacetResultNode> var3);

    @Override
    public final FacetResult compute() throws IOException {
        int pqsize;
        ParallelTaxonomyArrays arrays = this.taxonomyReader.getParallelTaxonomyArrays();
        int[] children = arrays.children();
        int[] siblings = arrays.siblings();
        int rootOrd = this.taxonomyReader.getOrdinal(this.facetRequest.categoryPath);
        FacetResultNode root = new FacetResultNode(rootOrd, this.valueOf(rootOrd));
        root.label = this.facetRequest.categoryPath;
        if (this.facetRequest.numResults > this.taxonomyReader.getSize()) {
            ArrayList<FacetResultNode> nodes = new ArrayList<FacetResultNode>();
            int child = children[rootOrd];
            this.addSiblings(child, siblings, nodes);
            Collections.sort(nodes, new Comparator<FacetResultNode>(){

                @Override
                public int compare(FacetResultNode o1, FacetResultNode o2) {
                    int value = (int)(o2.value - o1.value);
                    if (value == 0) {
                        value = o2.ordinal - o1.ordinal;
                    }
                    return value;
                }
            });
            root.subResults = nodes;
            return new FacetResult(this.facetRequest, root, nodes.size());
        }
        FacetResultNodeQueue pq = new FacetResultNodeQueue(this.facetRequest.numResults, true);
        int numSiblings = this.addSiblings(children[rootOrd], siblings, pq);
        int size = numSiblings < (pqsize = pq.size()) ? numSiblings : pqsize;
        for (int i = pqsize - size; i > 0; --i) {
            pq.pop();
        }
        FacetResultNode[] subResults = new FacetResultNode[size];
        for (int i = size - 1; i >= 0; --i) {
            FacetResultNode node = (FacetResultNode)pq.pop();
            node.label = this.taxonomyReader.getPath(node.ordinal);
            subResults[i] = node;
        }
        root.subResults = Arrays.asList(subResults);
        return new FacetResult(this.facetRequest, root, numSiblings);
    }

    private static class FacetResultNodeQueue
    extends PriorityQueue<FacetResultNode> {
        public FacetResultNodeQueue(int maxSize, boolean prepopulate) {
            super(maxSize, prepopulate);
        }

        protected FacetResultNode getSentinelObject() {
            return new FacetResultNode(-1, 0.0);
        }

        protected boolean lessThan(FacetResultNode a, FacetResultNode b) {
            if (a.value < b.value) {
                return true;
            }
            if (a.value > b.value) {
                return false;
            }
            return a.ordinal < b.ordinal;
        }
    }
}

