/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public final class DrillDownQuery
extends Query {
    private final BooleanQuery query;
    private final Map<String, Integer> drillDownDims = new LinkedHashMap<String, Integer>();
    final FacetIndexingParams fip;

    public static Term term(FacetIndexingParams iParams, CategoryPath path) {
        CategoryListParams clp = iParams.getCategoryListParams(path);
        char[] buffer = new char[path.fullPathLength()];
        iParams.drillDownTermText(path, buffer);
        return new Term(clp.field, String.valueOf(buffer));
    }

    DrillDownQuery(FacetIndexingParams fip, BooleanQuery query, Map<String, Integer> drillDownDims) {
        this.fip = fip;
        this.query = query.clone();
        this.drillDownDims.putAll(drillDownDims);
    }

    DrillDownQuery(Filter filter, DrillDownQuery other) {
        this.query = new BooleanQuery(true);
        BooleanClause[] clauses = other.query.getClauses();
        if (clauses.length == other.drillDownDims.size()) {
            throw new IllegalArgumentException("cannot apply filter unless baseQuery isn't null; pass ConstantScoreQuery instead");
        }
        assert (clauses.length == 1 + other.drillDownDims.size()) : clauses.length + " vs " + (1 + other.drillDownDims.size());
        this.drillDownDims.putAll(other.drillDownDims);
        this.query.add((Query)new FilteredQuery(clauses[0].getQuery(), filter), BooleanClause.Occur.MUST);
        for (int i = 1; i < clauses.length; ++i) {
            this.query.add(clauses[i].getQuery(), BooleanClause.Occur.MUST);
        }
        this.fip = other.fip;
    }

    DrillDownQuery(FacetIndexingParams fip, Query baseQuery, List<Query> clauses) {
        this.fip = fip;
        this.query = new BooleanQuery(true);
        if (baseQuery != null) {
            this.query.add(baseQuery, BooleanClause.Occur.MUST);
        }
        for (Query clause : clauses) {
            this.query.add(clause, BooleanClause.Occur.MUST);
            this.drillDownDims.put(this.getDim(clause), this.drillDownDims.size());
        }
    }

    String getDim(Query clause) {
        assert (clause instanceof ConstantScoreQuery);
        clause = ((ConstantScoreQuery)clause).getQuery();
        assert (clause instanceof TermQuery || clause instanceof BooleanQuery);
        String term = clause instanceof TermQuery ? ((TermQuery)clause).getTerm().text() : ((TermQuery)((BooleanQuery)clause).getClauses()[0].getQuery()).getTerm().text();
        return term.split(Pattern.quote(Character.toString(this.fip.getFacetDelimChar())), 2)[0];
    }

    public DrillDownQuery(FacetIndexingParams fip) {
        this(fip, null);
    }

    public DrillDownQuery(FacetIndexingParams fip, Query baseQuery) {
        this.query = new BooleanQuery(true);
        if (baseQuery != null) {
            this.query.add(baseQuery, BooleanClause.Occur.MUST);
        }
        this.fip = fip;
    }

    public void add(CategoryPath ... paths) {
        TermQuery q;
        if (paths[0].length == 0) {
            throw new IllegalArgumentException("all CategoryPaths must have length > 0");
        }
        String dim = paths[0].components[0];
        if (this.drillDownDims.containsKey(dim)) {
            throw new IllegalArgumentException("dimension '" + dim + "' was already added");
        }
        if (paths.length == 1) {
            q = new TermQuery(DrillDownQuery.term(this.fip, paths[0]));
        } else {
            BooleanQuery bq = new BooleanQuery(true);
            for (CategoryPath cp : paths) {
                if (cp.length == 0) {
                    throw new IllegalArgumentException("all CategoryPaths must have length > 0");
                }
                if (!cp.components[0].equals(dim)) {
                    throw new IllegalArgumentException("multiple (OR'd) drill-down paths must be under same dimension; got '" + dim + "' and '" + cp.components[0] + "'");
                }
                bq.add((Query)new TermQuery(DrillDownQuery.term(this.fip, cp)), BooleanClause.Occur.SHOULD);
            }
            q = bq;
        }
        this.drillDownDims.put(dim, this.drillDownDims.size());
        ConstantScoreQuery drillDownQuery = new ConstantScoreQuery((Query)q);
        drillDownQuery.setBoost(0.0f);
        this.query.add((Query)drillDownQuery, BooleanClause.Occur.MUST);
    }

    public DrillDownQuery clone() {
        return new DrillDownQuery(this.fip, this.query, this.drillDownDims);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.query.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DrillDownQuery)) {
            return false;
        }
        DrillDownQuery other = (DrillDownQuery)((Object)obj);
        return this.query.equals((Object)other.query) && super.equals((Object)other);
    }

    public Query rewrite(IndexReader r) throws IOException {
        if (this.query.clauses().size() == 0) {
            throw new IllegalStateException("no base query or drill-down categories given");
        }
        return this.query;
    }

    public String toString(String field) {
        return this.query.toString(field);
    }

    BooleanQuery getBooleanQuery() {
        return this.query;
    }

    Map<String, Integer> getDims() {
        return this.drillDownDims;
    }
}

