/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.taxonomy.CategoryPath;

public class FacetResultNode {
    public static final List<FacetResultNode> EMPTY_SUB_RESULTS = Collections.emptyList();
    public int ordinal;
    public CategoryPath label;
    public double value;
    public List<FacetResultNode> subResults = EMPTY_SUB_RESULTS;

    public FacetResultNode(int ordinal, double value) {
        this.ordinal = ordinal;
        this.value = value;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder(prefix);
        if (this.label == null) {
            sb.append("not labeled (ordinal=").append(this.ordinal).append(")");
        } else {
            sb.append(this.label.toString());
        }
        sb.append(" (").append(Double.toString(this.value)).append(")");
        for (FacetResultNode sub : this.subResults) {
            sb.append("\n").append(prefix).append(sub.toString(prefix + "  "));
        }
        return sb.toString();
    }
}

