/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSidewaysQuery;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.MultiFacets;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;

public class DrillSideways {
    protected final IndexSearcher searcher;
    protected final TaxonomyReader taxoReader;
    protected final SortedSetDocValuesReaderState state;
    protected final FacetsConfig config;

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader) {
        this(searcher, config, taxoReader, null);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, SortedSetDocValuesReaderState state) {
        this(searcher, config, null, state);
    }

    public DrillSideways(IndexSearcher searcher, FacetsConfig config, TaxonomyReader taxoReader, SortedSetDocValuesReaderState state) {
        this.searcher = searcher;
        this.config = config;
        this.taxoReader = taxoReader;
        this.state = state;
    }

    protected Facets buildFacetsResult(FacetsCollector drillDowns, FacetsCollector[] drillSideways, String[] drillSidewaysDims) throws IOException {
        Facets drillDownFacets;
        HashMap<String, Facets> drillSidewaysFacets = new HashMap<String, Facets>();
        if (this.taxoReader != null) {
            drillDownFacets = new FastTaxonomyFacetCounts(this.taxoReader, this.config, drillDowns);
            if (drillSideways != null) {
                for (int i = 0; i < drillSideways.length; ++i) {
                    drillSidewaysFacets.put(drillSidewaysDims[i], new FastTaxonomyFacetCounts(this.taxoReader, this.config, drillSideways[i]));
                }
            }
        } else {
            drillDownFacets = new SortedSetDocValuesFacetCounts(this.state, drillDowns);
            if (drillSideways != null) {
                for (int i = 0; i < drillSideways.length; ++i) {
                    drillSidewaysFacets.put(drillSidewaysDims[i], new SortedSetDocValuesFacetCounts(this.state, drillSideways[i]));
                }
            }
        }
        if (drillSidewaysFacets.isEmpty()) {
            return drillDownFacets;
        }
        return new MultiFacets(drillSidewaysFacets, drillDownFacets);
    }

    public DrillSidewaysResult search(DrillDownQuery query, Collector hitCollector) throws IOException {
        int startClause;
        MatchAllDocsQuery baseQuery;
        Map<String, Integer> drillDownDims = query.getDims();
        FacetsCollector drillDownCollector = new FacetsCollector();
        if (drillDownDims.isEmpty()) {
            this.searcher.search((Query)query, MultiCollector.wrap((Collector[])new Collector[]{hitCollector, drillDownCollector}));
            return new DrillSidewaysResult(this.buildFacetsResult(drillDownCollector, null, null), null);
        }
        BooleanQuery ddq = query.getBooleanQuery();
        BooleanClause[] clauses = ddq.getClauses();
        if (clauses.length == drillDownDims.size()) {
            baseQuery = new MatchAllDocsQuery();
            startClause = 0;
        } else {
            assert (clauses.length == 1 + drillDownDims.size());
            baseQuery = clauses[0].getQuery();
            startClause = 1;
        }
        FacetsCollector[] drillSidewaysCollectors = new FacetsCollector[drillDownDims.size()];
        for (int i = 0; i < drillSidewaysCollectors.length; ++i) {
            drillSidewaysCollectors[i] = new FacetsCollector();
        }
        Query[] drillDownQueries = new Query[clauses.length - startClause];
        for (int i = startClause; i < clauses.length; ++i) {
            drillDownQueries[i - startClause] = clauses[i].getQuery();
        }
        DrillSidewaysQuery dsq = new DrillSidewaysQuery((Query)baseQuery, (Collector)drillDownCollector, (Collector[])drillSidewaysCollectors, drillDownQueries, this.scoreSubDocsAtOnce());
        this.searcher.search((Query)dsq, hitCollector);
        return new DrillSidewaysResult(this.buildFacetsResult(drillDownCollector, drillSidewaysCollectors, drillDownDims.keySet().toArray(new String[drillDownDims.size()])), null);
    }

    public DrillSidewaysResult search(DrillDownQuery query, Filter filter, FieldDoc after, int topN, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        if (filter != null) {
            query = new DrillDownQuery(this.config, filter, query);
        }
        if (sort != null) {
            int limit = this.searcher.getIndexReader().maxDoc();
            if (limit == 0) {
                limit = 1;
            }
            topN = Math.min(topN, limit);
            TopFieldCollector hitCollector = TopFieldCollector.create((Sort)sort, (int)topN, (FieldDoc)after, (boolean)true, (boolean)doDocScores, (boolean)doMaxScore);
            DrillSidewaysResult r = this.search(query, (Collector)hitCollector);
            return new DrillSidewaysResult(r.facets, hitCollector.topDocs());
        }
        return this.search((ScoreDoc)after, query, topN);
    }

    public DrillSidewaysResult search(DrillDownQuery query, int topN) throws IOException {
        return this.search(null, query, topN);
    }

    public DrillSidewaysResult search(ScoreDoc after, DrillDownQuery query, int topN) throws IOException {
        int limit = this.searcher.getIndexReader().maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        topN = Math.min(topN, limit);
        TopScoreDocCollector hitCollector = TopScoreDocCollector.create((int)topN, (ScoreDoc)after);
        DrillSidewaysResult r = this.search(query, (Collector)hitCollector);
        return new DrillSidewaysResult(r.facets, hitCollector.topDocs());
    }

    protected boolean scoreSubDocsAtOnce() {
        return false;
    }

    public static class DrillSidewaysResult {
        public final Facets facets;
        public final TopDocs hits;

        public DrillSidewaysResult(Facets facets, TopDocs hits) {
            this.facets = facets;
            this.hits = hits;
        }
    }
}

