/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;

public final class LongRange
extends Range {
    final long minIncl;
    final long maxIncl;
    public final long min;
    public final long max;
    public final boolean minInclusive;
    public final boolean maxInclusive;

    public LongRange(String label, long minIn, boolean minInclusive, long maxIn, boolean maxInclusive) {
        super(label);
        this.min = minIn;
        this.max = maxIn;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        if (!minInclusive) {
            if (minIn != Long.MAX_VALUE) {
                ++minIn;
            } else {
                this.failNoMatch();
            }
        }
        if (!maxInclusive) {
            if (maxIn != Long.MIN_VALUE) {
                --maxIn;
            } else {
                this.failNoMatch();
            }
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.minIncl = minIn;
        this.maxIncl = maxIn;
    }

    public boolean accept(long value) {
        return value >= this.minIncl && value <= this.maxIncl;
    }

    public String toString() {
        return "LongRange(" + this.minIncl + " to " + this.maxIncl + ")";
    }

    @Override
    public Filter getFilter(final Filter fastMatchFilter, final ValueSource valueSource) {
        return new Filter(){

            public String toString() {
                return "Filter(" + LongRange.this.toString() + ")";
            }

            public DocIdSet getDocIdSet(LeafReaderContext context, final Bits acceptDocs) throws IOException {
                Bits fastMatchBits;
                final FunctionValues values = valueSource.getValues(Collections.emptyMap(), context);
                final int maxDoc = context.reader().maxDoc();
                if (fastMatchFilter != null) {
                    DocIdSet dis = fastMatchFilter.getDocIdSet(context, null);
                    if (dis == null) {
                        return null;
                    }
                    fastMatchBits = dis.bits();
                    if (fastMatchBits == null) {
                        throw new IllegalArgumentException("fastMatchFilter does not implement DocIdSet.bits");
                    }
                } else {
                    fastMatchBits = null;
                }
                return new DocIdSet(){

                    public Bits bits() {
                        return new Bits(){

                            public boolean get(int docID) {
                                if (acceptDocs != null && !acceptDocs.get(docID)) {
                                    return false;
                                }
                                if (fastMatchBits != null && !fastMatchBits.get(docID)) {
                                    return false;
                                }
                                return LongRange.this.accept(values.longVal(docID));
                            }

                            public int length() {
                                return maxDoc;
                            }
                        };
                    }

                    public DocIdSetIterator iterator() {
                        throw new UnsupportedOperationException("this filter can only be accessed via bits()");
                    }

                    public long ramBytesUsed() {
                        return 0L;
                    }
                };
            }
        };
    }
}

